/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.perspective.editor.layout.editor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IsWidget;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.InputSize;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.uberfire.client.mvp.ActivityBeansInfo;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.layout.editor.client.api.HasModalConfiguration;
import org.uberfire.ext.layout.editor.client.api.ModalConfigurationContext;
import org.uberfire.ext.layout.editor.client.api.RenderingContext;
import org.uberfire.ext.plugin.client.perspective.editor.api.PerspectiveEditorDragComponent;
import org.uberfire.ext.plugin.client.perspective.editor.layout.editor.popups.EditScreen;
import org.uberfire.ext.plugin.client.resources.i18n.CommonConstants;
import org.uberfire.ext.plugin.event.NewPluginRegistered;
import org.uberfire.ext.plugin.event.PluginUnregistered;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.ext.properties.editor.model.PropertyEditorChangeEvent;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@ApplicationScoped
public class ScreenLayoutDragComponent
implements PerspectiveEditorDragComponent,
HasModalConfiguration {
    public static final String PLACE_NAME_PARAMETER = "Place Name";
    @Inject
    private PlaceManager placeManager;
    protected List<String> availableWorkbenchScreensIds = new ArrayList<String>();
    private EditScreen editScreen;
    private ModalConfigurationContext configContext;

    @PostConstruct
    public void setup() {
        this.updateScreensList();
    }

    public IsWidget getDragWidget() {
        TextBox textBox = (TextBox)GWT.create(TextBox.class);
        textBox.setPlaceholder(CommonConstants.INSTANCE.ScreenComponent());
        textBox.setReadOnly(true);
        textBox.setSize(InputSize.DEFAULT);
        return textBox;
    }

    public IsWidget getPreviewWidget(RenderingContext ctx) {
        return this.getShowWidget(ctx);
    }

    public IsWidget getShowWidget(RenderingContext ctx) {
        FlowPanel panel = (FlowPanel)GWT.create(FlowPanel.class);
        Map<String, String> properties = this.extractScreenProperties(ctx);
        String placeName = properties.get(PLACE_NAME_PARAMETER);
        if (placeName == null) {
            return null;
        }
        this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest(placeName, properties), (HasWidgets)panel);
        return panel;
    }

    private Map<String, String> extractScreenProperties(RenderingContext ctx) {
        Map properties = ctx.getComponent().getProperties();
        HashMap<String, String> newProperties = new HashMap<String, String>();
        for (String key : properties.keySet()) {
            newProperties.put(key, (String)properties.get(key));
        }
        newProperties.put("random", "" + new Random().nextLong());
        return newProperties;
    }

    public Modal getConfigurationModal(ModalConfigurationContext ctx) {
        this.configContext = ctx;
        return new EditScreen(ctx, this.availableWorkbenchScreensIds);
    }

    public void observeEditComponentEventFromPropertyEditor(@Observes PropertyEditorChangeEvent event) {
        PropertyEditorFieldInfo property = event.getProperty();
        if (property.getEventId().equalsIgnoreCase(EditScreen.PROPERTY_EDITOR_KEY)) {
            this.configContext.setComponentProperty(property.getLabel(), property.getCurrentStringValue());
        }
    }

    public void onNewPluginRegistered(@Observes NewPluginRegistered newPluginRegistered) {
        if (newPluginRegistered.getType().equals((Object)PluginType.SCREEN) && !this.availableWorkbenchScreensIds.contains(newPluginRegistered.getName())) {
            this.getActivityBeansInfo().addActivityBean(this.availableWorkbenchScreensIds, newPluginRegistered.getName());
        }
    }

    public void onPluginUnregistered(@Observes PluginUnregistered pluginUnregistered) {
        if (pluginUnregistered.getType().equals((Object)PluginType.SCREEN)) {
            this.availableWorkbenchScreensIds.remove(pluginUnregistered.getName());
        }
    }

    protected void updateScreensList() {
        ActivityBeansInfo activityBeansInfo = this.getActivityBeansInfo();
        this.availableWorkbenchScreensIds = activityBeansInfo.getAvailableWorkbenchScreensIds();
    }

    ActivityBeansInfo getActivityBeansInfo() {
        SyncBeanDef activityBeansInfoIOCBeanDef = IOC.getBeanManager().lookupBean(ActivityBeansInfo.class, new Annotation[0]);
        return (ActivityBeansInfo)activityBeansInfoIOCBeanDef.getInstance();
    }

    List<String> getAvailableWorkbenchScreensIds() {
        return this.availableWorkbenchScreensIds;
    }
}

