/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.editor.commons.client.BaseEditorView;
import org.uberfire.ext.plugin.client.editor.RuntimePluginBaseEditor;
import org.uberfire.ext.plugin.client.editor.RuntimePluginBaseView;
import org.uberfire.ext.plugin.event.PluginAdded;
import org.uberfire.ext.plugin.event.PluginDeleted;
import org.uberfire.ext.plugin.event.PluginRenamed;
import org.uberfire.ext.plugin.event.PluginSaved;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.model.PluginContent;
import org.uberfire.ext.plugin.model.PluginSimpleContent;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.ext.plugin.service.PluginServices;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.ParameterizedCommand;

@RunWith(value=GwtMockitoTestRunner.class)
public class RuntimePluginBaseEditorTest {
    RemoteCallback<PluginContent> successCallBack;
    RuntimePluginBaseView baseEditorView = null;
    private PluginServices pluginServices;
    private CallerMock<PluginServices> callerMock;
    private RuntimePluginBaseEditor editor;

    @Before
    public void setup() {
        this.pluginServices = (PluginServices)Mockito.mock(PluginServices.class);
        this.callerMock = new CallerMock((Object)this.pluginServices);
        this.successCallBack = (RemoteCallback)Mockito.mock(RemoteCallback.class);
        this.baseEditorView = (RuntimePluginBaseView)Mockito.mock(RuntimePluginBaseView.class);
        this.editor = (RuntimePluginBaseEditor)Mockito.spy((Object)this.createRuntimePluginBaseEditor());
    }

    @Test
    public void loadContentTest() {
        PluginContent pluginContent = (PluginContent)Mockito.mock(PluginContent.class);
        Mockito.when((Object)this.pluginServices.getPluginContent((Path)Matchers.any())).thenReturn((Object)pluginContent);
        Assert.assertNull((Object)this.editor.getOriginalHash());
        this.editor.loadContent();
        ((PluginServices)Mockito.verify((Object)this.pluginServices)).getPluginContent((Path)Matchers.any());
        ((RuntimePluginBaseView)Mockito.verify((Object)this.baseEditorView)).setFramework(Mockito.anyCollection());
        ((RuntimePluginBaseView)Mockito.verify((Object)this.baseEditorView)).setupContent((PluginContent)Mockito.eq((Object)pluginContent), (ParameterizedCommand)Matchers.any());
        ((RuntimePluginBaseView)Mockito.verify((Object)this.baseEditorView)).hideBusyIndicator();
        Assert.assertNotNull((Object)this.editor.getOriginalHash());
    }

    @Test
    public void pluginSavedTest() {
        this.editor.onPluginSaved((PluginSaved)Mockito.mock(PluginSaved.class));
        ((RuntimePluginBaseEditor)Mockito.verify((Object)this.editor)).registerPlugin((Plugin)Mockito.any(Plugin.class));
    }

    @Test
    public void pluginAddedTest() {
        this.editor.onPluginAdded((PluginAdded)Mockito.mock(PluginAdded.class));
        ((RuntimePluginBaseEditor)Mockito.verify((Object)this.editor)).registerPlugin((Plugin)Mockito.any(Plugin.class));
    }

    @Test
    public void pluginDeletedTest() {
        this.editor.onPluginDeleted((PluginDeleted)Mockito.mock(PluginDeleted.class));
        ((RuntimePluginBaseEditor)Mockito.verify((Object)this.editor)).unregisterPlugin((String)Mockito.any(String.class), (PluginType)Mockito.any(PluginType.class));
    }

    @Test
    public void pluginRenamedTest() {
        this.editor.onPluginRenamed((PluginRenamed)Mockito.mock(PluginRenamed.class));
        ((RuntimePluginBaseEditor)Mockito.verify((Object)this.editor)).unregisterPlugin((String)Mockito.any(String.class), (PluginType)Mockito.any(PluginType.class));
        ((RuntimePluginBaseEditor)Mockito.verify((Object)this.editor)).registerPlugin((Plugin)Mockito.any(Plugin.class));
    }

    @Test
    public void saveCommandTest() {
        this.editor.getSaveCommand().execute((Object)"commitMessage");
        ((RuntimePluginBaseView)Mockito.verify((Object)this.baseEditorView)).onSave();
    }

    private RuntimePluginBaseEditor createRuntimePluginBaseEditor() {
        return new RuntimePluginBaseEditor((BaseEditorView)this.baseEditorView){

            protected PluginType getPluginType() {
                return PluginType.DYNAMIC_MENU;
            }

            protected ClientResourceType getResourceType() {
                return null;
            }

            RuntimePluginBaseView view() {
                return RuntimePluginBaseEditorTest.this.baseEditorView;
            }

            Caller<PluginServices> getPluginServices() {
                return RuntimePluginBaseEditorTest.this.callerMock;
            }

            ObservablePath getCurrentPath() {
                return (ObservablePath)Mockito.mock(ObservablePath.class);
            }

            public PluginSimpleContent getContent() {
                return (PluginSimpleContent)Mockito.mock(PluginSimpleContent.class);
            }

            void unregisterPlugin(String name, PluginType type) {
            }

            void registerPlugin(Plugin plugin) {
            }

            protected RemoteCallback<Path> getSaveSuccessCallback(int newHash) {
                return path -> {};
            }
        };
    }
}

