/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.perspective.editor.layout.editor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IsWidget;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Modal;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.uberfire.client.mvp.ActivityBeansInfo;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.layout.editor.client.api.HasModalConfiguration;
import org.uberfire.ext.layout.editor.client.api.LayoutDragComponent;
import org.uberfire.ext.layout.editor.client.api.ModalConfigurationContext;
import org.uberfire.ext.layout.editor.client.api.RenderingContext;
import org.uberfire.ext.plugin.client.perspective.editor.layout.editor.popups.EditScreen;
import org.uberfire.ext.plugin.client.resources.i18n.CommonConstants;
import org.uberfire.ext.plugin.event.NewPluginRegistered;
import org.uberfire.ext.plugin.event.PluginUnregistered;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.ext.properties.editor.model.PropertyEditorChangeEvent;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@ApplicationScoped
public class ScreenLayoutDragComponent
implements LayoutDragComponent,
HasModalConfiguration {
    public static final String PLACE_NAME_PARAMETER = "Place Name";
    protected List<String> availableWorkbenchScreensIds = new ArrayList<String>();
    private PlaceManager placeManager;
    private ModalConfigurationContext configContext;

    @Inject
    public ScreenLayoutDragComponent(PlaceManager placeManager) {
        this.placeManager = placeManager;
    }

    @PostConstruct
    public void setup() {
        this.updateScreensList();
    }

    public String getDragComponentTitle() {
        return CommonConstants.INSTANCE.ScreenComponent();
    }

    public String getDragComponentIconClass() {
        return "fa fa-desktop";
    }

    public IsWidget getPreviewWidget(RenderingContext ctx) {
        return this.getShowWidget(ctx);
    }

    public void removeCurrentWidget(RenderingContext ctx) {
        DefaultPlaceRequest place = this.buildPlaceRequest(ctx.getComponent().getProperties());
        if (place != null) {
            this.placeManager.closePlace((PlaceRequest)place);
        }
    }

    public IsWidget getShowWidget(RenderingContext ctx) {
        FlowPanel panel = (FlowPanel)GWT.create(FlowPanel.class);
        panel.asWidget().getElement().addClassName("uf-perspective-col");
        panel.asWidget().getElement().addClassName("screen dnd component");
        DefaultPlaceRequest place = this.buildPlaceRequest(ctx.getComponent().getProperties());
        if (place == null) {
            return null;
        }
        this.placeManager.goTo((PlaceRequest)place, (HasWidgets)panel);
        return panel;
    }

    DefaultPlaceRequest buildPlaceRequest(Map<String, String> properties) {
        String placeName = properties.get(PLACE_NAME_PARAMETER);
        if (placeName == null) {
            return null;
        }
        DefaultPlaceRequest place = new DefaultPlaceRequest(placeName, properties, false);
        return place;
    }

    public Modal getConfigurationModal(ModalConfigurationContext ctx) {
        this.configContext = ctx;
        return new EditScreen(ctx, this.availableWorkbenchScreensIds, this.createCleanupPlaceRequest(this.buildPlaceRequest(ctx.getComponentProperties())));
    }

    Command createCleanupPlaceRequest(DefaultPlaceRequest placeToClose) {
        return () -> this.placeManager.closePlace((PlaceRequest)placeToClose);
    }

    public void observeEditComponentEventFromPropertyEditor(@Observes PropertyEditorChangeEvent event) {
        PropertyEditorFieldInfo property = event.getProperty();
        if (property.getEventId().equalsIgnoreCase(EditScreen.PROPERTY_EDITOR_KEY)) {
            this.configContext.setComponentProperty(property.getLabel(), property.getCurrentStringValue());
        }
    }

    public void onNewPluginRegistered(@Observes NewPluginRegistered newPluginRegistered) {
        if (newPluginRegistered.getType().equals((Object)PluginType.SCREEN) && !this.availableWorkbenchScreensIds.contains(newPluginRegistered.getName())) {
            this.getActivityBeansInfo().addActivityBean(this.availableWorkbenchScreensIds, newPluginRegistered.getName());
        }
    }

    public void onPluginUnregistered(@Observes PluginUnregistered pluginUnregistered) {
        if (pluginUnregistered.getType().equals((Object)PluginType.SCREEN)) {
            this.availableWorkbenchScreensIds.remove(pluginUnregistered.getName());
        }
    }

    protected void updateScreensList() {
        ActivityBeansInfo activityBeansInfo = this.getActivityBeansInfo();
        this.availableWorkbenchScreensIds = activityBeansInfo.getAvailableWorkbenchScreensIds();
    }

    ActivityBeansInfo getActivityBeansInfo() {
        SyncBeanDef activityBeansInfoIOCBeanDef = IOC.getBeanManager().lookupBean(ActivityBeansInfo.class, new Annotation[0]);
        return (ActivityBeansInfo)activityBeansInfoIOCBeanDef.getInstance();
    }

    List<String> getAvailableWorkbenchScreensIds() {
        return this.availableWorkbenchScreensIds;
    }
}

