/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.perspective.editor.layout.editor;

import java.util.ArrayList;
import java.util.List;
import org.uberfire.ext.layout.editor.api.editor.LayoutColumn;
import org.uberfire.ext.layout.editor.api.editor.LayoutComponent;
import org.uberfire.ext.layout.editor.api.editor.LayoutRow;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.ext.plugin.client.perspective.editor.layout.editor.TargetDivDragComponent;

public class TargetDivList {
    public static List<String> list(LayoutTemplate layout) {
        ArrayList<String> ids = new ArrayList<String>();
        List rows = layout.getRows();
        TargetDivList.searchForComponents(rows, ids);
        return ids;
    }

    private static void searchForComponents(List<LayoutRow> rows, List<String> ids) {
        for (LayoutRow layoutRow : rows) {
            for (LayoutColumn layoutColumn : layoutRow.getLayoutColumns()) {
                if (TargetDivList.columnHasNestedRows(layoutColumn)) {
                    TargetDivList.searchForComponents(layoutColumn.getRows(), ids);
                    continue;
                }
                TargetDivList.extractTargetDiv(layoutColumn.getLayoutComponents(), ids);
            }
        }
    }

    private static void extractTargetDiv(List<LayoutComponent> layoutComponents, List<String> ids) {
        for (LayoutComponent layoutComponent : layoutComponents) {
            if (!TargetDivList.isATargetDiv(layoutComponent)) continue;
            ids.add((String)layoutComponent.getProperties().get("ID_PARAMETER"));
        }
    }

    private static boolean isATargetDiv(LayoutComponent layoutComponent) {
        return layoutComponent.getDragTypeName().equalsIgnoreCase(TargetDivDragComponent.class.getName());
    }

    private static boolean columnHasNestedRows(LayoutColumn layoutColumn) {
        return layoutColumn.getRows() != null && !layoutColumn.getRows().isEmpty();
    }
}

