/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.perspective.editor.layout.editor;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.ext.plugin.client.perspective.editor.layout.editor.TargetDivList;

public class TargetDivListTest {
    public static final String SAMPLE_LAYOUT = "org/uberfire/ext/plugin/client/perspective/editor/layout/editor/fullLayoutPage.txt";
    private Gson gson = new GsonBuilder().setPrettyPrinting().create();

    @Test
    public void getAllTargetDivsTest() throws Exception {
        LayoutTemplate layout = this.loadLayout(SAMPLE_LAYOUT);
        List divs = TargetDivList.list((LayoutTemplate)layout);
        Assert.assertEquals((long)3L, (long)divs.size());
        Assert.assertTrue((boolean)divs.contains("dora_div_id"));
        Assert.assertTrue((boolean)divs.contains("bento_div_id"));
        Assert.assertTrue((boolean)divs.contains("another_div_id"));
    }

    public LayoutTemplate loadLayout(String templateURL) throws Exception {
        URL resource = this.getClass().getClassLoader().getResource(templateURL);
        String layoutEditorModel = new String(Files.readAllBytes(Paths.get(resource.toURI())));
        LayoutTemplate layoutTemplate = (LayoutTemplate)this.gson.fromJson(layoutEditorModel, LayoutTemplate.class);
        return layoutTemplate;
    }
}

