/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.perspective.editor.layout.editor.popups;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.shared.TimeZone;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.uberfire.ext.layout.editor.client.api.ModalConfigurationContext;
import org.uberfire.ext.plugin.client.resources.i18n.CommonConstants;
import org.uberfire.ext.properties.editor.client.PropertyEditorWidget;
import org.uberfire.ext.properties.editor.model.PropertyEditorCategory;
import org.uberfire.ext.properties.editor.model.PropertyEditorEvent;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;
import org.uberfire.ext.properties.editor.model.PropertyEditorType;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.ButtonPressed;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

public class EditTargetDiv
extends BaseModal {
    public static String PROPERTY_EDITOR_KEY = "EditTargetDiv";
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    private final ModalConfigurationContext configContext;
    @UiField
    PropertyEditorWidget propertyEditor;
    private ButtonPressed buttonPressed = ButtonPressed.CLOSE;
    private Map<String, String> lastParametersSaved = new HashMap<String, String>();

    public EditTargetDiv(ModalConfigurationContext configContext) {
        this.configContext = configContext;
        this.setTitle(CommonConstants.INSTANCE.EditComponent());
        this.setBody((Widget)uiBinder.createAndBindUi((Object)this));
        this.propertyEditor.handle(this.generateEvent(this.generatedPropertyEditor()));
        this.saveOriginalState();
        this.add((Widget)new ModalFooterOKCancelButtons(() -> this.okButton(), () -> this.cancelButton()));
        this.addHiddenHandler();
    }

    private void saveOriginalState() {
        this.lastParametersSaved = new HashMap<String, String>();
        Map layoutComponentProperties = this.configContext.getComponentProperties();
        for (String key : layoutComponentProperties.keySet()) {
            this.lastParametersSaved.put(key, (String)layoutComponentProperties.get(key));
        }
    }

    protected void addHiddenHandler() {
        this.addHiddenHandler(hiddenEvent -> {
            if (this.userPressedCloseOrCancel()) {
                this.revertChanges();
                this.configContext.configurationCancelled();
            }
        });
    }

    private boolean userPressedCloseOrCancel() {
        return ButtonPressed.CANCEL.equals((Object)this.buttonPressed) || ButtonPressed.CLOSE.equals((Object)this.buttonPressed);
    }

    private void revertChanges() {
        this.configContext.resetComponentProperties();
        for (String key : this.lastParametersSaved.keySet()) {
            this.configContext.setComponentProperty(key, this.lastParametersSaved.get(key));
        }
    }

    public void show() {
        super.show();
    }

    void okButton() {
        this.buttonPressed = ButtonPressed.OK;
        if (this.configContext.getComponentProperty("ID_PARAMETER") == null) {
            this.configContext.setComponentProperty("ID_PARAMETER", this.generateRandomID());
            this.configContext.configurationFinished();
        } else {
            this.configContext.configurationFinished();
        }
        this.hide();
    }

    private String generateRandomID() {
        Date date = new Date();
        DateTimeFormat dtf = DateTimeFormat.getFormat((String)"yyyyMMddHHmmss");
        String randomID = "id-" + dtf.format(date, (TimeZone)com.google.gwt.i18n.client.TimeZone.createTimeZone((int)0));
        return randomID;
    }

    void cancelButton() {
        this.buttonPressed = ButtonPressed.CANCEL;
        this.hide();
    }

    public void hide() {
        super.hide();
    }

    private PropertyEditorCategory generatedPropertyEditor() {
        PropertyEditorCategory category = new PropertyEditorCategory(CommonConstants.INSTANCE.TargetDivConfiguration());
        Map parameters = this.configContext.getComponentProperties();
        String selectedID = (String)parameters.get("ID_PARAMETER");
        category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.TargetDivPlaceHolder(), selectedID == null ? "" : selectedID, PropertyEditorType.TEXT).withKey(this.configContext.hashCode() + "ID_PARAMETER"));
        this.propertyEditor.addExpandedCategory(new String[]{category.getName()});
        return category;
    }

    private PropertyEditorEvent generateEvent(PropertyEditorCategory category) {
        PropertyEditorEvent event = new PropertyEditorEvent(PROPERTY_EDITOR_KEY, category);
        return event;
    }

    protected ModalConfigurationContext getConfigContext() {
        return this.configContext;
    }

    static interface Binder
    extends UiBinder<Widget, EditTargetDiv> {
    }
}

