/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.widget.popup;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.ModalBody;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.ext.plugin.client.resources.i18n.CommonConstants;
import org.uberfire.ext.plugin.client.widget.popup.NewPluginPopUpView;
import org.uberfire.ext.plugin.model.PluginType;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

@Dependent
public class NewPluginPopUpViewImpl
extends BaseModal
implements NewPluginPopUpView {
    private static ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);
    @UiField
    TextBox name;
    @UiField
    HelpBlock nameHelpInline;
    @UiField
    FormGroup nameGroup;
    private NewPluginPopUpView.Presenter presenter;
    private final Command cancelCommand = new Command(){

        public void execute() {
            NewPluginPopUpViewImpl.this.presenter.onCancel();
        }
    };
    private PluginType type;
    private final Command okCommand = new Command(){

        public void execute() {
            NewPluginPopUpViewImpl.this.onOKButtonClick();
        }
    };
    private final ModalFooterOKCancelButtons footer = new ModalFooterOKCancelButtons(this.okCommand, this.cancelCommand);

    public void init(NewPluginPopUpView.Presenter presenter) {
        this.presenter = presenter;
        this.footer.enableOkButton(true);
        this.add((Widget)new ModalBody(){
            {
                this.add((Widget)uiBinder.createAndBindUi(NewPluginPopUpViewImpl.this));
            }
        });
        this.add((Widget)this.footer);
    }

    @Override
    public void show(PluginType type) {
        this.type = (PluginType)PortablePreconditions.checkNotNull((String)"type", (Object)type);
        this.name.setText("");
        this.nameHelpInline.setText("");
        this.nameGroup.setValidationState(ValidationState.NONE);
        switch (this.type) {
            case PERSPECTIVE: {
                this.setTitle(CommonConstants.INSTANCE.NewPerspectivePopUpTitle());
                break;
            }
            case PERSPECTIVE_LAYOUT: {
                this.setTitle(CommonConstants.INSTANCE.NewPerspectiveLayoutPopUpTitle());
                break;
            }
            case SCREEN: {
                this.setTitle(CommonConstants.INSTANCE.NewScreenPopUpTitle());
                break;
            }
            case EDITOR: {
                this.setTitle(CommonConstants.INSTANCE.NewEditorPopUpTitle());
                break;
            }
            case SPLASH: {
                this.setTitle(CommonConstants.INSTANCE.NewSplashScreenPopUpTitle());
                break;
            }
            case DYNAMIC_MENU: {
                this.setTitle(CommonConstants.INSTANCE.NewDynamicMenuPopUpTitle());
            }
        }
        super.show();
    }

    private void onOKButtonClick() {
        this.presenter.onOK(this.name.getText(), this.type);
    }

    @Override
    public void handleNameValidationError(String errorMessage) {
        this.nameGroup.setValidationState(ValidationState.ERROR);
        this.nameHelpInline.setText(errorMessage);
    }

    @Override
    public String emptyName() {
        return "Name is mandatory.";
    }

    @Override
    public String invalidName() {
        return "Invalid plugin name.";
    }

    @Override
    public String duplicatedName() {
        return "Plugin name already exists.";
    }

    static interface ViewBinder
    extends UiBinder<Widget, NewPluginPopUpViewImpl> {
    }
}

