/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.info;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.client.mvp.ActivityBeansInfo;
import org.uberfire.client.workbench.type.ClientTypeRegistry;
import org.uberfire.ext.plugin.client.info.PluginsInfo;
import org.uberfire.ext.plugin.client.type.DynamicMenuResourceType;
import org.uberfire.ext.plugin.client.type.EditorPluginResourceType;
import org.uberfire.ext.plugin.client.type.PerspectiveLayoutPluginResourceType;
import org.uberfire.ext.plugin.client.type.ScreenPluginResourceType;
import org.uberfire.ext.plugin.client.type.SplashPluginResourceType;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.model.PluginType;

public class PluginsInfoTest {
    private PluginsInfo pluginsInfo;
    private EditorPluginResourceType editorPluginResourceType;
    private PerspectiveLayoutPluginResourceType perspectiveLayoutPluginResourceType;
    private ScreenPluginResourceType screenPluginResourceType;
    private SplashPluginResourceType splashPluginResourceType;
    private DynamicMenuResourceType dynamicMenuResourceType;
    private ActivityBeansInfo activityBeansInfo;
    private ClientTypeRegistry clientTypeRegistry;

    @Before
    public void setup() {
        this.editorPluginResourceType = (EditorPluginResourceType)Mockito.mock(EditorPluginResourceType.class);
        this.perspectiveLayoutPluginResourceType = (PerspectiveLayoutPluginResourceType)Mockito.mock(PerspectiveLayoutPluginResourceType.class);
        this.screenPluginResourceType = (ScreenPluginResourceType)Mockito.mock(ScreenPluginResourceType.class);
        this.splashPluginResourceType = (SplashPluginResourceType)Mockito.mock(SplashPluginResourceType.class);
        this.dynamicMenuResourceType = (DynamicMenuResourceType)Mockito.mock(DynamicMenuResourceType.class);
        this.activityBeansInfo = (ActivityBeansInfo)Mockito.mock(ActivityBeansInfo.class);
        this.clientTypeRegistry = (ClientTypeRegistry)Mockito.mock(ClientTypeRegistry.class);
        Mockito.when((Object)this.activityBeansInfo.getAvailableWorkbenchEditorsIds()).thenReturn(Arrays.asList("editorId1"));
        Mockito.when((Object)this.activityBeansInfo.getAvailablePerspectivesIds()).thenReturn(Arrays.asList("perspectiveId1", "perspectiveId2"));
        Mockito.when((Object)this.activityBeansInfo.getAvailableWorkbenchScreensIds()).thenReturn(Arrays.asList("screenId1", "screenId2", "screenId3"));
        Mockito.when((Object)this.activityBeansInfo.getAvailableSplashScreensIds()).thenReturn(Arrays.asList("splashScreenId1", "splashScreenId2", "splashScreenId3", "splashScreenId4"));
        Mockito.when((Object)this.clientTypeRegistry.resolve((Path)Mockito.any(Path.class))).thenReturn((Object)this.dynamicMenuResourceType);
        this.pluginsInfo = (PluginsInfo)Mockito.spy((Object)new PluginsInfo(this.editorPluginResourceType, this.perspectiveLayoutPluginResourceType, this.screenPluginResourceType, this.splashPluginResourceType, this.dynamicMenuResourceType, this.activityBeansInfo, this.clientTypeRegistry));
        ((PluginsInfo)Mockito.doReturn(Collections.emptyList()).when((Object)this.pluginsInfo)).lookupBeans((Class)Mockito.any(Class.class));
    }

    @Test
    public void getAllPluginsTest() {
        Set allPlugins = this.pluginsInfo.getAllPlugins(this.getPlugins());
        Assert.assertEquals((long)15L, (long)allPlugins.size());
    }

    @Test
    public void getClassifiedPluginsTest() {
        Map classifiedPlugins = this.pluginsInfo.getClassifiedPlugins(this.getPlugins());
        Assert.assertEquals((long)5L, (long)classifiedPlugins.keySet().size());
        Assert.assertEquals((long)1L, (long)((Set)classifiedPlugins.get(this.editorPluginResourceType)).size());
        Assert.assertEquals((long)2L, (long)((Set)classifiedPlugins.get(this.perspectiveLayoutPluginResourceType)).size());
        Assert.assertEquals((long)3L, (long)((Set)classifiedPlugins.get(this.screenPluginResourceType)).size());
        Assert.assertEquals((long)4L, (long)((Set)classifiedPlugins.get(this.splashPluginResourceType)).size());
        Assert.assertEquals((long)5L, (long)((Set)classifiedPlugins.get(this.dynamicMenuResourceType)).size());
    }

    private Set<Plugin> getPlugins() {
        HashSet<Plugin> plugins = new HashSet<Plugin>();
        plugins.add(new Plugin("existingPerspectiveLayout", PluginType.PERSPECTIVE_LAYOUT, PathFactory.newPath((String)"test1", (String)"/tmp/test1")));
        plugins.add(new Plugin("existingScreen", PluginType.SCREEN, PathFactory.newPath((String)"test2", (String)"/tmp/test2")));
        plugins.add(new Plugin("existingEditor", PluginType.EDITOR, PathFactory.newPath((String)"test3", (String)"/tmp/test3")));
        plugins.add(new Plugin("existingSplashScreen", PluginType.SPLASH, PathFactory.newPath((String)"test4", (String)"/tmp/test4")));
        plugins.add(new Plugin("existingDynamicMenu", PluginType.DYNAMIC_MENU, PathFactory.newPath((String)"test5", (String)"/tmp/test5")));
        return plugins;
    }
}

