/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.client.perspective.editor.generator;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collections;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.ext.layout.editor.api.PerspectiveServices;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.ext.layout.editor.client.generator.LayoutGenerator;
import org.uberfire.ext.plugin.client.perspective.editor.generator.PerspectiveEditorActivity;
import org.uberfire.ext.plugin.client.perspective.editor.generator.PerspectiveEditorGenerator;
import org.uberfire.ext.plugin.client.perspective.editor.generator.PerspectiveEditorScreenActivity;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class PerspectiveEditorGeneratorTest {
    @Mock
    LayoutGenerator layoutGenerator;
    @Mock
    ActivityBeansCache activityBeansCache;
    @Mock
    SyncBeanManager beanManager;
    @Mock
    PerspectiveServices perspectiveServices;
    @Mock
    SyncBeanDef activityBeanDef;
    PerspectiveEditorGenerator generator;

    @Before
    public void setUp() {
        Mockito.when((Object)this.beanManager.lookupBeans(Mockito.anyString())).thenReturn(Collections.singleton(this.activityBeanDef));
        Mockito.when((Object)this.beanManager.lookupBeans(SyncBeanDef.class)).thenReturn(Collections.singleton(this.activityBeanDef));
        this.generator = new PerspectiveEditorGenerator(this.beanManager, this.activityBeansCache, this.layoutGenerator, (Caller)new CallerMock((Object)this.perspectiveServices));
    }

    @Test
    public void testGeneratedActivitiesIdentifier() {
        LayoutTemplate layoutTemplate = new LayoutTemplate("test");
        PerspectiveEditorActivity perspectiveActivity = this.generator.generatePerspective(layoutTemplate);
        PerspectiveEditorScreenActivity screenActivity = perspectiveActivity.getScreen();
        Assert.assertNotNull((Object)perspectiveActivity);
        Assert.assertNotNull((Object)screenActivity);
        Assert.assertEquals((Object)perspectiveActivity.getIdentifier(), (Object)"test");
        Assert.assertEquals((Object)screenActivity.getIdentifier(), (Object)"test [Screen]");
    }
}

