/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.screens.home;

import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.uberfire.client.annotations.WorkbenchContextId;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.resources.i18n.UsersManagementWorkbenchConstants;
import org.uberfire.ext.security.management.client.screens.BaseScreen;
import org.uberfire.ext.security.management.client.screens.home.EntitiesManagementHome;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;

@Dependent
@WorkbenchScreen(identifier="GroupsManagementHomeScreen")
public class GroupsManagementHomeScreen {
    public static final String SCREEN_ID = "GroupsManagementHomeScreen";
    @Inject
    ClientUserSystemManager clientUserSystemManager;
    @Inject
    BaseScreen baseScreen;
    @Inject
    EntitiesManagementHome view;

    @PostConstruct
    public void init() {
        this.baseScreen.init(this.view);
    }

    @OnStartup
    public void onStartup(PlaceRequest placeRequest) {
        this.show();
    }

    @OnOpen
    public void onOpen() {
    }

    @OnClose
    public void onClose() {
    }

    public void show() {
        ArrayList<String> homeEnabledItems = new ArrayList<String>(4);
        if (this.clientUserSystemManager.isGroupCapabilityEnabled(Capability.CAN_ADD_GROUP)) {
            homeEnabledItems.add(UsersManagementWorkbenchConstants.INSTANCE.home_createGroup());
        }
        homeEnabledItems.add(UsersManagementWorkbenchConstants.INSTANCE.home_listSearchGroups());
        if (this.clientUserSystemManager.isGroupCapabilityEnabled(Capability.CAN_READ_GROUP)) {
            homeEnabledItems.add(UsersManagementWorkbenchConstants.INSTANCE.home_clickOnGroupInListToRead());
        }
        if (this.clientUserSystemManager.isGroupCapabilityEnabled(Capability.CAN_DELETE_GROUP)) {
            homeEnabledItems.add(UsersManagementWorkbenchConstants.INSTANCE.home_deleteGroup());
        }
        this.view.show(UsersManagementWorkbenchConstants.INSTANCE.groupEditorWelcomeText(), homeEnabledItems);
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return UsersManagementWorkbenchConstants.INSTANCE.groupsManagementHome();
    }

    @WorkbenchPartView
    public Widget getWidget() {
        return this.baseScreen.asWidget();
    }

    @WorkbenchContextId
    public String getMyContextRef() {
        return "groupsManagementHomeContext";
    }
}

