/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.screens.home;

import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.uberfire.client.annotations.WorkbenchContextId;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.resources.i18n.UsersManagementWorkbenchConstants;
import org.uberfire.ext.security.management.client.screens.BaseScreen;
import org.uberfire.ext.security.management.client.screens.home.EntitiesManagementHome;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;

@Dependent
@WorkbenchScreen(identifier="UsersManagementHomeScreen")
public class UsersManagementHomeScreen {
    public static final String SCREEN_ID = "UsersManagementHomeScreen";
    @Inject
    ClientUserSystemManager clientUserSystemManager;
    @Inject
    BaseScreen baseScreen;
    @Inject
    EntitiesManagementHome view;

    @PostConstruct
    public void init() {
        this.baseScreen.init(this.view);
    }

    @OnStartup
    public void onStartup(PlaceRequest placeRequest) {
        this.show();
    }

    @OnOpen
    public void onOpen() {
    }

    @OnClose
    public void onClose() {
    }

    public void show() {
        ArrayList<String> homeEnabledItems = new ArrayList<String>(4);
        if (this.clientUserSystemManager.isUserCapabilityEnabled(Capability.CAN_ADD_USER)) {
            homeEnabledItems.add(UsersManagementWorkbenchConstants.INSTANCE.home_createUser());
        }
        homeEnabledItems.add(UsersManagementWorkbenchConstants.INSTANCE.home_listSearchUsers());
        if (this.clientUserSystemManager.isUserCapabilityEnabled(Capability.CAN_READ_USER)) {
            homeEnabledItems.add(UsersManagementWorkbenchConstants.INSTANCE.home_clickOnUserInListToRead());
        }
        if (this.clientUserSystemManager.isUserCapabilityEnabled(Capability.CAN_DELETE_USER)) {
            homeEnabledItems.add(UsersManagementWorkbenchConstants.INSTANCE.home_editAndDeleteUser());
        }
        this.view.show(UsersManagementWorkbenchConstants.INSTANCE.userEditorWelcomeText(), homeEnabledItems);
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return UsersManagementWorkbenchConstants.INSTANCE.usersManagementHome();
    }

    @WorkbenchPartView
    public Widget getWidget() {
        return this.baseScreen.asWidget();
    }

    @WorkbenchContextId
    public String getMyContextRef() {
        return "usersManagementHomeContext";
    }
}

