/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.screens.explorer;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.resources.i18n.UsersManagementWorkbenchConstants;
import org.uberfire.ext.security.management.client.widgets.management.events.NewGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.NewUserEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnErrorEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.ReadGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.ReadRoleEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.ReadUserEvent;
import org.uberfire.ext.security.management.client.widgets.management.explorer.GroupsExplorer;
import org.uberfire.ext.security.management.client.widgets.management.explorer.RolesExplorer;
import org.uberfire.ext.security.management.client.widgets.management.explorer.UsersExplorer;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@Dependent
@WorkbenchScreen(identifier="SecurityExplorerScreen")
public class SecurityExplorerScreen {
    public static final String SCREEN_ID = "SecurityExplorerScreen";
    public static final String ROLES_TAB = "RolesTab";
    public static final String GROUPS_TAB = "GroupsTab";
    public static final String USERS_TAB = "UsersTab";
    @Inject
    View view;
    @Inject
    RolesExplorer rolesExplorer;
    @Inject
    GroupsExplorer groupsExplorer;
    @Inject
    UsersExplorer usersExplorer;
    @Inject
    ErrorPopupPresenter errorPopupPresenter;
    @Inject
    PlaceManager placeManager;
    @Inject
    ClientUserSystemManager userSystemManager;

    @WorkbenchPartTitle
    public String getTitle() {
        return UsersManagementWorkbenchConstants.INSTANCE.securityExplorer();
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return this.view;
    }

    @PostConstruct
    public void init() {
        this.view.init(this, (IsWidget)this.rolesExplorer, (IsWidget)this.groupsExplorer, (IsWidget)this.usersExplorer);
        this.rolesExplorer.show();
        this.view.rolesEnabled(true);
        this.view.groupsEnabled(false);
        this.view.usersEnabled(false);
    }

    @OnStartup
    public void onStartup(PlaceRequest placeRequest) {
        String activeTab = placeRequest.getParameter("activeTab", ROLES_TAB);
        this.userSystemManager.waitForInitialization(() -> {
            if (this.userSystemManager.isActive()) {
                this.groupsExplorer.show();
                this.usersExplorer.show();
                this.view.groupsEnabled(true);
                this.view.usersEnabled(true);
                if (activeTab.equals(USERS_TAB)) {
                    this.view.rolesActive(false);
                    this.view.groupsActive(false);
                    this.view.usersActive(true);
                } else if (activeTab.equals(GROUPS_TAB)) {
                    this.view.rolesActive(false);
                    this.view.groupsActive(true);
                    this.view.usersActive(false);
                }
            }
        });
    }

    @OnClose
    public void onClose() {
        this.rolesExplorer.clear();
        this.groupsExplorer.clear();
        this.usersExplorer.clear();
    }

    void onRoleRead(@Observes ReadRoleEvent readRoleEvent) {
        PortablePreconditions.checkNotNull((String)"event", (Object)readRoleEvent);
        String name = readRoleEvent.getName();
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("roleName", name);
        this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest("RoleEditorScreen", params));
    }

    void onGroupRead(@Observes ReadGroupEvent readGroupEvent) {
        String name = readGroupEvent.getName();
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("groupName", name);
        this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest("GroupEditorScreen", params));
    }

    void onUserRead(@Observes ReadUserEvent readUserEvent) {
        PortablePreconditions.checkNotNull((String)"event", (Object)readUserEvent);
        String id = readUserEvent.getIdentifier();
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("userId", id);
        this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest("UserEditorScreen", params));
    }

    void onGroupCreate(@Observes NewGroupEvent newGroupEvent) {
        PortablePreconditions.checkNotNull((String)"event", (Object)newGroupEvent);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("addGroup", "true");
        this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest("GroupEditorScreen", params));
    }

    void onUserCreate(@Observes NewUserEvent newUserEvent) {
        PortablePreconditions.checkNotNull((String)"event", (Object)newUserEvent);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("addUser", "true");
        this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest("UserEditorScreen", params));
    }

    void onErrorEvent(@Observes OnErrorEvent onErrorEvent) {
        PortablePreconditions.checkNotNull((String)"event", (Object)onErrorEvent);
        Throwable cause = onErrorEvent.getCause();
        String message = onErrorEvent.getMessage();
        String m = message != null ? message : cause.getMessage();
        this.errorPopupPresenter.showMessage(m);
    }

    public static interface View
    extends UberView<SecurityExplorerScreen> {
        public void init(SecurityExplorerScreen var1, IsWidget var2, IsWidget var3, IsWidget var4);

        public void rolesEnabled(boolean var1);

        public void groupsEnabled(boolean var1);

        public void usersEnabled(boolean var1);

        public void rolesActive(boolean var1);

        public void groupsActive(boolean var1);

        public void usersActive(boolean var1);
    }
}

