/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.editor.group;

import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.editor.Driver;
import org.uberfire.ext.security.management.client.editor.group.GroupEditor;
import org.uberfire.security.authz.PermissionCollection;

@Dependent
public class GroupEditorDriver
implements Driver<Group, GroupEditor> {
    ClientUserSystemManager userSystemManager;
    GroupEditor groupEditor;
    Group group;
    boolean isFlushed = false;
    boolean isEditMode = false;

    @Inject
    public GroupEditorDriver(ClientUserSystemManager userSystemManager) {
        this.userSystemManager = userSystemManager;
    }

    @Override
    public void show(Group group, GroupEditor groupEditor) {
        this.isFlushed = false;
        this.isEditMode = false;
        this.group = group;
        this.groupEditor = groupEditor;
        groupEditor.show(group);
    }

    @Override
    public void edit(Group group, GroupEditor groupEditor) {
        this.isFlushed = false;
        this.isEditMode = true;
        this.group = group;
        this.groupEditor = groupEditor;
        groupEditor.edit(group);
    }

    @Override
    public boolean flush() {
        assert (this.isEditMode);
        this.isFlushed = true;
        this.groupEditor.flush();
        String name = this.groupEditor.name();
        this.group = new GroupImpl(name);
        Set violations = this.userSystemManager.groupsValidator().validate((Object)this.group);
        this.groupEditor.setViolations(violations);
        return violations == null || violations.isEmpty();
    }

    @Override
    public Group getValue() {
        assert (this.isFlushed);
        return this.group;
    }

    public PermissionCollection getPermissions() {
        return this.groupEditor.permissions();
    }

    public PerspectiveActivity getHomePerspective() {
        return this.groupEditor.homePerspective();
    }

    public int getGroupPriority() {
        return this.groupEditor.groupPriority();
    }
}

