/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.editor.role;

import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.editor.Driver;
import org.uberfire.ext.security.management.client.editor.role.RoleEditor;
import org.uberfire.security.authz.PermissionCollection;

@Dependent
public class RoleEditorDriver
implements Driver<Role, RoleEditor> {
    ClientUserSystemManager userSystemManager;
    RoleEditor roleEditor;
    Role role;
    boolean isFlushed = false;
    boolean isEditMode = false;

    @Inject
    public RoleEditorDriver(ClientUserSystemManager userSystemManager) {
        this.userSystemManager = userSystemManager;
    }

    @Override
    public void show(Role role, RoleEditor roleEditor) {
        this.isFlushed = false;
        this.isEditMode = false;
        this.role = role;
        this.roleEditor = roleEditor;
        roleEditor.show(role);
    }

    @Override
    public void edit(Role role, RoleEditor roleEditor) {
        this.isFlushed = false;
        this.isEditMode = true;
        this.role = role;
        this.roleEditor = roleEditor;
        roleEditor.edit(role);
    }

    @Override
    public boolean flush() {
        assert (this.isEditMode);
        this.isFlushed = true;
        this.roleEditor.flush();
        String name = this.roleEditor.name();
        this.role = new RoleImpl(name);
        Set violations = this.userSystemManager.rolesValidator().validate((Object)this.role);
        this.roleEditor.setViolations(violations);
        return violations == null || violations.isEmpty();
    }

    @Override
    public Role getValue() {
        assert (this.isFlushed);
        return this.role;
    }

    public PerspectiveActivity getHomePerspective() {
        return this.roleEditor.homePerspective();
    }

    public int getRolePriority() {
        return this.roleEditor.rolePriority();
    }

    public PermissionCollection getPermissions() {
        return this.roleEditor.permissions();
    }
}

