/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.keycloak;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.resteasy.client.ClientResponse;
import org.keycloak.representations.idm.RoleRepresentation;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.api.CapabilityStatus;
import org.uberfire.ext.security.management.api.ContextualManager;
import org.uberfire.ext.security.management.api.GroupManager;
import org.uberfire.ext.security.management.api.GroupManagerSettings;
import org.uberfire.ext.security.management.api.UserSystemManager;
import org.uberfire.ext.security.management.api.exception.GroupNotFoundException;
import org.uberfire.ext.security.management.api.exception.SecurityManagementException;
import org.uberfire.ext.security.management.api.exception.UnsupportedServiceCapabilityException;
import org.uberfire.ext.security.management.api.exception.UserNotFoundException;
import org.uberfire.ext.security.management.impl.GroupManagerSettingsImpl;
import org.uberfire.ext.security.management.keycloak.BaseKeyCloakManager;
import org.uberfire.ext.security.management.keycloak.client.resource.RoleResource;
import org.uberfire.ext.security.management.keycloak.client.resource.RolesResource;
import org.uberfire.ext.security.management.keycloak.client.resource.UserResource;
import org.uberfire.ext.security.management.keycloak.client.resource.UsersResource;
import org.uberfire.ext.security.management.search.GroupsRuntimeSearchEngine;
import org.uberfire.ext.security.management.search.RuntimeSearchEngine;
import org.uberfire.ext.security.management.util.SecurityManagementUtils;

public class KeyCloakGroupManager
extends BaseKeyCloakManager
implements GroupManager,
ContextualManager {
    private static final Logger LOG = LoggerFactory.getLogger(KeyCloakGroupManager.class);
    RuntimeSearchEngine<Group> groupsSearchEngine;

    public void initialize(UserSystemManager userSystemManager) throws Exception {
        this.groupsSearchEngine = new GroupsRuntimeSearchEngine();
    }

    public AbstractEntityManager.SearchResponse<Group> search(AbstractEntityManager.SearchRequest request) throws SecurityManagementException {
        if (request.getPage() <= 0) {
            throw new RuntimeException("First page must be 1.");
        }
        LinkedList roles = new LinkedList();
        this.consumeRealm(realmResource -> {
            RolesResource rolesResource = realmResource.roles();
            List<RoleRepresentation> roleRepresentations = rolesResource.list();
            if (roleRepresentations != null && !roleRepresentations.isEmpty()) {
                for (RoleRepresentation role : roleRepresentations) {
                    String name = role.getName();
                    Group group = this.createGroup(name);
                    roles.add(group);
                }
            }
        });
        return this.groupsSearchEngine.search(roles, request);
    }

    public Group get(String identifier) throws SecurityManagementException {
        RoleRepresentation roleRepresentation;
        Group g;
        PortablePreconditions.checkNotNull((String)"identifier", (Object)identifier);
        RoleResource[] roleResource = new RoleResource[1];
        this.consumeRealm(realmResource -> {
            RolesResource rolesResource = realmResource.roles();
            roleResource[0] = rolesResource.get(identifier);
        });
        if (roleResource[0] != null && (g = this.createGroup(roleRepresentation = this.getRoleRepresentation(identifier, roleResource[0]))) != null) {
            return g;
        }
        throw new GroupNotFoundException(identifier);
    }

    public Group create(Group entity) throws SecurityManagementException {
        PortablePreconditions.checkNotNull((String)"entity", (Object)entity);
        this.consumeRealm(realmResource -> {
            RolesResource rolesResource = realmResource.roles();
            RoleRepresentation roleRepresentation = new RoleRepresentation();
            roleRepresentation.setName(entity.getName());
            roleRepresentation.setDescription(entity.getName());
            roleRepresentation.setScopeParamRequired(Boolean.valueOf(false));
            roleRepresentation.setId(entity.getName());
            roleRepresentation.setComposite(false);
            ClientResponse response = (ClientResponse)rolesResource.create(roleRepresentation);
            this.handleResponse(response);
        });
        return entity;
    }

    public Group update(Group entity) throws SecurityManagementException {
        throw new UnsupportedServiceCapabilityException(Capability.CAN_UPDATE_GROUP);
    }

    public void delete(String ... identifiers) throws SecurityManagementException {
        PortablePreconditions.checkNotNull((String)"identifiers", (Object)identifiers);
        this.consumeRealm(realmResource -> {
            RolesResource rolesResource = realmResource.roles();
            for (String identifier : identifiers) {
                RoleResource roleResource = rolesResource.get(identifier);
                if (roleResource == null) {
                    throw new GroupNotFoundException(identifier);
                }
                roleResource.remove();
            }
        });
    }

    public GroupManagerSettings getSettings() {
        HashMap<Capability, CapabilityStatus> capabilityStatusMap = new HashMap<Capability, CapabilityStatus>(8);
        for (Capability capability : SecurityManagementUtils.GROUPS_CAPABILITIES) {
            capabilityStatusMap.put(capability, this.getCapabilityStatus(capability));
        }
        return new GroupManagerSettingsImpl(capabilityStatusMap, true);
    }

    public void assignUsers(String name, Collection<String> users) throws SecurityManagementException {
        PortablePreconditions.checkNotNull((String)"name", (Object)name);
        if (users != null) {
            this.consumeRealm(realmResource -> {
                UsersResource usersResource = realmResource.users();
                RolesResource rolesResource = realmResource.roles();
                RoleResource roleResource = rolesResource.get(name);
                ArrayList<RoleRepresentation> rolesToAdd = new ArrayList<RoleRepresentation>(1);
                rolesToAdd.add(this.getRoleRepresentation(name, roleResource));
                for (String username : users) {
                    UserResource userResource = this.getUserResource(usersResource, username);
                    if (userResource == null) {
                        throw new UserNotFoundException(username);
                    }
                    userResource.roles().realmLevel().add(rolesToAdd);
                }
            });
        }
    }

    protected CapabilityStatus getCapabilityStatus(Capability capability) {
        if (capability != null) {
            switch (capability) {
                case CAN_SEARCH_GROUPS: 
                case CAN_ADD_GROUP: 
                case CAN_READ_GROUP: 
                case CAN_DELETE_GROUP: {
                    return CapabilityStatus.ENABLED;
                }
            }
        }
        return CapabilityStatus.UNSUPPORTED;
    }

    public void destroy() throws Exception {
        this.getKeyCloakInstance().close();
    }
}

