/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.tomcat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.catalina.Role;
import org.apache.catalina.users.MemoryUserDatabase;
import org.jboss.errai.security.shared.api.identity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.config.ConfigProperties;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.api.CapabilityStatus;
import org.uberfire.ext.security.management.api.ContextualManager;
import org.uberfire.ext.security.management.api.UserManager;
import org.uberfire.ext.security.management.api.UserManagerSettings;
import org.uberfire.ext.security.management.api.UserSystemManager;
import org.uberfire.ext.security.management.api.exception.SecurityManagementException;
import org.uberfire.ext.security.management.impl.UserManagerSettingsImpl;
import org.uberfire.ext.security.management.search.IdentifierRuntimeSearchEngine;
import org.uberfire.ext.security.management.search.UsersIdentifierRuntimeSearchEngine;
import org.uberfire.ext.security.management.tomcat.BaseTomcatManager;
import org.uberfire.ext.security.management.util.SecurityManagementUtils;

public class TomcatUserManager
extends BaseTomcatManager
implements UserManager,
ContextualManager {
    private static final Logger LOG = LoggerFactory.getLogger(TomcatUserManager.class);
    UserSystemManager userSystemManager;
    IdentifierRuntimeSearchEngine<User> usersSearchEngine;

    public TomcatUserManager() {
        this(new ConfigProperties(System.getProperties()));
    }

    public TomcatUserManager(Map<String, String> gitPrefs) {
        this(new ConfigProperties(gitPrefs));
    }

    public TomcatUserManager(ConfigProperties gitPrefs) {
        this.loadConfig(gitPrefs);
    }

    public void initialize(UserSystemManager userSystemManager) throws Exception {
        this.userSystemManager = userSystemManager;
        this.usersSearchEngine = new UsersIdentifierRuntimeSearchEngine();
    }

    public void destroy() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractEntityManager.SearchResponse<User> search(AbstractEntityManager.SearchRequest request) throws SecurityManagementException {
        MemoryUserDatabase userDatabase = this.getDatabase();
        try {
            Iterator users = userDatabase.getUsers();
            ArrayList<String> userIdentifiers = new ArrayList<String>();
            if (users != null) {
                while (users.hasNext()) {
                    org.apache.catalina.User user = (org.apache.catalina.User)users.next();
                    String username = user.getUsername();
                    userIdentifiers.add(username);
                }
            }
            AbstractEntityManager.SearchResponse searchResponse = this.usersSearchEngine.searchByIdentifiers(userIdentifiers, request);
            return searchResponse;
        }
        finally {
            this.closeDatabase(userDatabase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User get(String identifier) throws SecurityManagementException {
        MemoryUserDatabase userDatabase = this.getDatabase();
        try {
            org.apache.catalina.User user = this.getUser(userDatabase, identifier);
            Iterator groups = user.getRoles();
            User u = this.createUser(user, groups);
            u.setProperty("user.fullName", user.getFullName() != null ? user.getFullName() : "");
            User user2 = u;
            return user2;
        }
        finally {
            this.closeDatabase(userDatabase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User create(User entity) throws SecurityManagementException {
        if (entity == null) {
            throw new NullPointerException();
        }
        MemoryUserDatabase userDatabase = this.getDatabase();
        try {
            String username = entity.getIdentifier();
            String fullName = entity.getProperty("user.fullName");
            userDatabase.createUser(username, "", fullName != null ? fullName : "");
            this.saveDatabase(userDatabase);
            User user = entity;
            return user;
        }
        finally {
            this.closeDatabase(userDatabase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User update(User entity) throws SecurityManagementException {
        if (entity == null) {
            throw new NullPointerException();
        }
        MemoryUserDatabase userDatabase = this.getDatabase();
        try {
            org.apache.catalina.User user = this.getUser(userDatabase, entity.getIdentifier());
            String fName = entity.getProperty("user.fullName");
            user.setFullName(fName != null ? fName : "");
            this.saveDatabase(userDatabase);
            User user2 = entity;
            return user2;
        }
        finally {
            this.closeDatabase(userDatabase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String ... identifiers) throws SecurityManagementException {
        if (identifiers == null) {
            throw new NullPointerException();
        }
        MemoryUserDatabase userDatabase = this.getDatabase();
        try {
            for (String identifier : identifiers) {
                org.apache.catalina.User user = this.getUser(userDatabase, identifier);
                userDatabase.removeUser(user);
            }
            this.saveDatabase(userDatabase);
        }
        finally {
            this.closeDatabase(userDatabase);
        }
    }

    public UserManagerSettings getSettings() {
        HashMap<Capability, CapabilityStatus> capabilityStatusMap = new HashMap<Capability, CapabilityStatus>(8);
        for (Capability capability : SecurityManagementUtils.USERS_CAPABILITIES) {
            capabilityStatusMap.put(capability, this.getCapabilityStatus(capability));
        }
        return new UserManagerSettingsImpl(capabilityStatusMap, USER_ATTRIBUTES);
    }

    public void assignGroups(String username, Collection<String> groups) throws SecurityManagementException {
        Set userRoles = SecurityManagementUtils.rolesToString((Set)SecurityManagementUtils.getRoles((UserSystemManager)this.userSystemManager, (String)username));
        userRoles.addAll(groups);
        this.doAssignGroups(username, userRoles);
    }

    public void assignRoles(String username, Collection<String> roles) throws SecurityManagementException {
        Set userGroups = SecurityManagementUtils.groupsToString((Set)SecurityManagementUtils.getGroups((UserSystemManager)this.userSystemManager, (String)username));
        userGroups.addAll(roles);
        this.doAssignGroups(username, userGroups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAssignGroups(String username, Collection<String> ids) throws SecurityManagementException {
        MemoryUserDatabase userDatabase = this.getDatabase();
        try {
            org.apache.catalina.User user = this.getUser(userDatabase, username);
            user.removeRoles();
            if (!ids.isEmpty()) {
                for (String roleName : ids) {
                    Role role = this.getRole(userDatabase, roleName);
                    user.addRole(role);
                }
            }
            this.saveDatabase(userDatabase);
        }
        finally {
            this.closeDatabase(userDatabase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePassword(String username, String newPassword) throws SecurityManagementException {
        if (username == null) {
            throw new NullPointerException();
        }
        MemoryUserDatabase userDatabase = this.getDatabase();
        try {
            org.apache.catalina.User user = this.getUser(userDatabase, username);
            user.setPassword(newPassword);
            this.saveDatabase(userDatabase);
        }
        finally {
            this.closeDatabase(userDatabase);
        }
    }

    protected CapabilityStatus getCapabilityStatus(Capability capability) {
        if (capability != null) {
            switch (capability) {
                case CAN_SEARCH_USERS: 
                case CAN_ADD_USER: 
                case CAN_UPDATE_USER: 
                case CAN_DELETE_USER: 
                case CAN_READ_USER: 
                case CAN_MANAGE_ATTRIBUTES: 
                case CAN_ASSIGN_GROUPS: 
                case CAN_ASSIGN_ROLES: 
                case CAN_CHANGE_PASSWORD: {
                    return CapabilityStatus.ENABLED;
                }
            }
        }
        return CapabilityStatus.UNSUPPORTED;
    }
}

