/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.wildfly.cli;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.config.ConfigProperties;

public abstract class BaseWildflyCLIManager {
    private static final Logger LOG = LoggerFactory.getLogger(BaseWildflyCLIManager.class);
    protected static final String DEFAULT_HOST = "localhost";
    protected static final int DEFAULT_PORT = 9990;
    protected static final String DEFAULT_ADMIN_USER = null;
    protected static final String DEFAULT_ADMIN_PASSWORD = null;
    protected static final String DEFAULT_REALM = "ApplicationRealm";
    protected String host;
    protected int port;
    protected String adminUser;
    protected String adminPassword;
    protected String realm;

    protected void loadConfig(ConfigProperties config) {
        ConfigProperties.ConfigProperty host = config.get("org.uberfire.ext.security.management.wildfly.cli.host", DEFAULT_HOST);
        ConfigProperties.ConfigProperty port = config.get("org.uberfire.ext.security.management.wildfly.cli.port", Integer.toString(9990));
        ConfigProperties.ConfigProperty user = config.get("org.uberfire.ext.security.management.wildfly.cli.user", DEFAULT_ADMIN_USER);
        ConfigProperties.ConfigProperty password = config.get("org.uberfire.ext.security.management.wildfly.cli.password", DEFAULT_ADMIN_PASSWORD);
        ConfigProperties.ConfigProperty realm = config.get("org.uberfire.ext.security.management.wildfly.cli.realm", DEFAULT_REALM);
        this.host = host.getValue();
        this.port = Integer.decode(port.getValue());
        this.adminUser = user.getValue();
        this.adminPassword = password.getValue();
        this.realm = realm.getValue();
    }

    public ModelControllerClient getClient() throws Exception {
        return ModelControllerClient.Factory.create((InetAddress)InetAddress.getByName(this.host), (int)this.port, (CallbackHandler)new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback current : callbacks) {
                    if (current instanceof NameCallback) {
                        NameCallback ncb = (NameCallback)current;
                        ncb.setName(BaseWildflyCLIManager.this.adminUser);
                        continue;
                    }
                    if (current instanceof PasswordCallback) {
                        PasswordCallback pcb = (PasswordCallback)current;
                        pcb.setPassword(BaseWildflyCLIManager.this.adminPassword.toCharArray());
                        continue;
                    }
                    if (current instanceof RealmCallback) {
                        RealmCallback rcb = (RealmCallback)current;
                        rcb.setText(rcb.getDefaultText());
                        continue;
                    }
                    throw new UnsupportedCallbackException(current);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getPropertiesFilePath(String context) throws Exception {
        String result = null;
        ModelControllerClient client = this.getClient();
        if (client != null) {
            ModelNode operation = new ModelNode();
            operation.get("operation").set("read-resource");
            ModelNode address = operation.get("address");
            address.add("core-service", "management");
            address.add("security-realm", this.realm);
            address.add(context, "properties");
            try {
                ModelNode resultNode;
                ModelNode returnVal = client.execute(operation);
                if ("success".equalsIgnoreCase(returnVal.get("outcome").asString()) && (resultNode = returnVal.get("result")) != null) {
                    String path = resultNode.get("path").asString();
                    String relativeTo = resultNode.get("relative-to").asString();
                    String relativeToPath = System.getProperty(relativeTo);
                    String string = new File(relativeToPath, path).getAbsolutePath();
                    return string;
                }
            }
            catch (Exception e) {
                LOG.error("Error reading realm using CLI commands.", (Throwable)e);
            }
            finally {
                client.close();
            }
        }
        return result;
    }

    protected static boolean isConfigPropertySet(ConfigProperties.ConfigProperty property) {
        if (property == null) {
            return false;
        }
        String value = property.getValue();
        return !BaseWildflyCLIManager.isEmpty(value);
    }

    protected static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }
}

