/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.wildfly.properties;

import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.config.ConfigProperties;
import org.wildfly.security.sasl.util.UsernamePasswordHashUtil;

public abstract class BaseWildflyPropertiesManager {
    public static final String DEFAULT_REALM = "ApplicationRealm";
    private static final Logger LOG = LoggerFactory.getLogger(BaseWildflyPropertiesManager.class);
    protected String realm = "ApplicationRealm";

    protected static String generateHashPassword(String username, String realm, String password) {
        String result = null;
        try {
            result = new UsernamePasswordHashUtil().generateHashedHexURP(username, realm, password.toCharArray());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return result;
    }

    protected static boolean isConfigPropertySet(ConfigProperties.ConfigProperty property) {
        if (property == null) {
            return false;
        }
        String value = property.getValue();
        return !BaseWildflyPropertiesManager.isEmpty(value);
    }

    protected static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    protected void loadConfig(ConfigProperties config) {
        ConfigProperties.ConfigProperty realm = config.get("org.uberfire.ext.security.management.wildfly.properties.realm", DEFAULT_REALM);
        this.realm = realm.getValue();
    }
}

