/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.wildfly.properties;

import java.util.Properties;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertiesLineWriterPredicate
implements Predicate<String> {
    public static final Pattern PROPERTY_PATTERN = Pattern.compile("#?+((?:[,.\\-@/a-zA-Z0-9]++|(?:\\\\[=\\\\])++)++)=(.++)");
    public static final Pattern EMPTY_PROPERTY_PATTERN = Pattern.compile("#?+((?:[,.\\-@/a-zA-Z0-9]++|(?:\\\\[=\\\\])++)++)=(\\[\\].*?)*");
    private final Function<String, String> keyRawValueProvider;
    private final boolean allowEmptyEntryValue;
    private Properties properties;

    public PropertiesLineWriterPredicate(Function<String, String> keyRawValueProvider, boolean allowEmptyEntryValue) {
        this.keyRawValueProvider = keyRawValueProvider;
        this.allowEmptyEntryValue = allowEmptyEntryValue;
    }

    public PropertiesLineWriterPredicate begin(Properties p) {
        this.properties = p;
        return this;
    }

    public PropertiesLineWriterPredicate end() {
        this.properties = null;
        return this;
    }

    @Override
    public boolean test(String line) {
        boolean result = false;
        String trimmed = line.trim();
        if (trimmed.length() > 0) {
            String username;
            String inMemoryValue;
            Matcher emptyPatternMatcher;
            Matcher userLineMatcher = null;
            boolean isEmptyValue = false;
            Matcher defaultPatternMatcher = PROPERTY_PATTERN.matcher(trimmed);
            if (defaultPatternMatcher.matches()) {
                userLineMatcher = defaultPatternMatcher;
            } else if (this.allowEmptyEntryValue && (emptyPatternMatcher = EMPTY_PROPERTY_PATTERN.matcher(trimmed)).matches()) {
                userLineMatcher = emptyPatternMatcher;
                isEmptyValue = true;
            }
            boolean bl = result = null == userLineMatcher;
            if (!result && null != (inMemoryValue = this.properties.getProperty(username = this.keyRawValueProvider.apply(userLineMatcher.group(1))))) {
                boolean isMemoryValueEmpty = 0 == inMemoryValue.trim().length();
                result = !isEmptyValue || isMemoryValueEmpty;
            }
        }
        return result;
    }
}

