/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.wildfly.filesystem;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.config.ConfigProperties;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.api.CapabilityStatus;
import org.uberfire.ext.security.management.api.ContextualManager;
import org.uberfire.ext.security.management.api.GroupManager;
import org.uberfire.ext.security.management.api.GroupManagerSettings;
import org.uberfire.ext.security.management.api.UserSystemManager;
import org.uberfire.ext.security.management.api.exception.GroupNotFoundException;
import org.uberfire.ext.security.management.api.exception.SecurityManagementException;
import org.uberfire.ext.security.management.api.exception.UnsupportedServiceCapabilityException;
import org.uberfire.ext.security.management.impl.GroupManagerSettingsImpl;
import org.uberfire.ext.security.management.search.GroupsIdentifierRuntimeSearchEngine;
import org.uberfire.ext.security.management.search.IdentifierRuntimeSearchEngine;
import org.uberfire.ext.security.management.util.SecurityManagementUtils;
import org.uberfire.ext.security.management.wildfly.filesystem.RealmProvider;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.FileSystemSecurityRealm;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.ModifiableRealmIdentityIterator;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.MapAttributes;

public class WildflyGroupFileSystemManager
implements GroupManager,
ContextualManager {
    private static final Logger LOG = LoggerFactory.getLogger(WildflyGroupFileSystemManager.class);
    protected final IdentifierRuntimeSearchEngine<Group> groupsSearchEngine = new GroupsIdentifierRuntimeSearchEngine();
    private final RealmProvider realmProvider;

    public WildflyGroupFileSystemManager() {
        this(new ConfigProperties(System.getProperties()));
    }

    public WildflyGroupFileSystemManager(Map<String, String> gitPrefs) {
        this(new ConfigProperties(gitPrefs));
    }

    public WildflyGroupFileSystemManager(ConfigProperties gitPrefs) {
        this.realmProvider = new RealmProvider(gitPrefs);
    }

    public AbstractEntityManager.SearchResponse<Group> search(AbstractEntityManager.SearchRequest request) throws SecurityManagementException {
        Set<String> result = this.getAllGroups();
        AbstractEntityManager.SearchResponse groupSearchResponse = this.groupsSearchEngine.searchByIdentifiers(result, request);
        return groupSearchResponse;
    }

    public Group get(String identifier) throws SecurityManagementException {
        if (identifier == null) {
            throw new NullPointerException();
        }
        Set<String> result = this.getAllGroups();
        if (result != null && result.contains(identifier)) {
            return SecurityManagementUtils.createGroup((String)identifier);
        }
        throw new GroupNotFoundException(identifier);
    }

    public List<Group> getAll() throws SecurityManagementException {
        HashSet<Group> result = new HashSet<Group>();
        Set<String> allGroup = this.getAllGroups();
        for (String groupName : allGroup) {
            result.add(SecurityManagementUtils.createGroup((String)groupName));
        }
        return new ArrayList<Group>(result);
    }

    protected Set<String> getAllGroups() {
        HashSet<String> result = new HashSet<String>();
        try {
            ModifiableRealmIdentityIterator realmIdentityIterator = this.realmProvider.getRealm().getRealmIdentityIterator();
            while (realmIdentityIterator.hasNext()) {
                ModifiableRealmIdentity identity = (ModifiableRealmIdentity)realmIdentityIterator.next();
                Attributes attributes = identity.getAttributes();
                Attributes.Entry roles = attributes.get("role");
                for (String role : roles) {
                    result.add(role);
                }
            }
        }
        catch (Exception e) {
            throw new SecurityManagementException((Throwable)e);
        }
        return result;
    }

    public Group create(Group entity) throws SecurityManagementException {
        if (entity == null) {
            throw new NullPointerException();
        }
        return new GroupImpl(entity.getName());
    }

    public Group update(Group entity) throws SecurityManagementException {
        throw new UnsupportedServiceCapabilityException(Capability.CAN_UPDATE_GROUP);
    }

    public void delete(String ... identifiers) throws SecurityManagementException {
        if (identifiers == null) {
            throw new NullPointerException();
        }
        List<String> groupsToBeRemoved = Arrays.asList(identifiers);
        try {
            ModifiableRealmIdentityIterator iterator = this.realmProvider.getRealm().getRealmIdentityIterator();
            while (iterator.hasNext()) {
                ModifiableRealmIdentity identity = (ModifiableRealmIdentity)iterator.next();
                MapAttributes attributes = new MapAttributes(identity.getAttributes());
                boolean found = false;
                HashSet<String> groups = new HashSet<String>();
                for (String group : identity.getAttributes().get("role")) {
                    if (groupsToBeRemoved.contains(group)) {
                        found = true;
                        continue;
                    }
                    groups.add(group);
                }
                attributes.remove("role");
                attributes.addAll("role", groups);
                if (!found) continue;
                identity.setAttributes((Attributes)attributes);
                identity.dispose();
            }
        }
        catch (Exception e) {
            LOG.error("Error removing the folowing group names: " + Arrays.toString(identifiers), (Throwable)e);
            throw new SecurityManagementException((Throwable)e);
        }
    }

    public GroupManagerSettings getSettings() {
        HashMap<Capability, CapabilityStatus> capabilityStatusMap = new HashMap<Capability, CapabilityStatus>(8);
        for (Capability capability : SecurityManagementUtils.GROUPS_CAPABILITIES) {
            capabilityStatusMap.put(capability, this.getCapabilityStatus(capability));
        }
        return new GroupManagerSettingsImpl(capabilityStatusMap, false);
    }

    protected CapabilityStatus getCapabilityStatus(Capability capability) {
        if (capability != null) {
            switch (capability) {
                case CAN_ADD_GROUP: 
                case CAN_DELETE_GROUP: 
                case CAN_SEARCH_GROUPS: 
                case CAN_READ_GROUP: {
                    return CapabilityStatus.ENABLED;
                }
            }
        }
        return CapabilityStatus.UNSUPPORTED;
    }

    public void initialize(UserSystemManager userSystemManager) {
    }

    public void destroy() throws Exception {
    }

    public void assignUsers(String groupName, Collection<String> users) throws SecurityManagementException {
        for (String username : users) {
            try {
                FileSystemSecurityRealm realm = this.realmProvider.getRealm();
                ModifiableRealmIdentity identity = realm.getRealmIdentityForUpdate((Principal)new NamePrincipal(username));
                MapAttributes attributes = new MapAttributes(identity.getAttributes());
                HashSet<String> groups = new HashSet<String>();
                for (String group : identity.getAttributes().get("role")) {
                    groups.add(group);
                }
                groups.add(groupName);
                attributes.addAll("role", groups);
                identity.setAttributes((Attributes)attributes);
                identity.dispose();
            }
            catch (RealmUnavailableException e) {
                throw new SecurityManagementException((Throwable)e);
            }
        }
    }
}

