/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.wildfly.filesystem;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jboss.errai.security.shared.api.identity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.config.ConfigProperties;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.api.CapabilityStatus;
import org.uberfire.ext.security.management.api.ContextualManager;
import org.uberfire.ext.security.management.api.UserManager;
import org.uberfire.ext.security.management.api.UserManagerSettings;
import org.uberfire.ext.security.management.api.UserSystemManager;
import org.uberfire.ext.security.management.api.exception.SecurityManagementException;
import org.uberfire.ext.security.management.api.exception.UserNotFoundException;
import org.uberfire.ext.security.management.impl.UserManagerSettingsImpl;
import org.uberfire.ext.security.management.search.IdentifierRuntimeSearchEngine;
import org.uberfire.ext.security.management.search.UsersIdentifierRuntimeSearchEngine;
import org.uberfire.ext.security.management.util.SecurityManagementUtils;
import org.uberfire.ext.security.management.wildfly.filesystem.RealmProvider;
import org.uberfire.ext.security.management.wildfly.filesystem.WildflyGroupFileSystemManager;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.FileSystemSecurityRealm;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.ModifiableRealmIdentityIterator;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.WildFlyElytronPasswordProvider;
import org.wildfly.security.password.interfaces.DigestPassword;
import org.wildfly.security.password.spec.DigestPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.DigestPasswordSpec;
import org.wildfly.security.password.spec.EncryptablePasswordSpec;

public class WildflyUserFileSystemManager
implements ContextualManager,
UserManager {
    private static final Logger LOG = LoggerFactory.getLogger(WildflyUserFileSystemManager.class);
    private static final Provider ELYTRON_PROVIDER = new WildFlyElytronPasswordProvider();
    protected final IdentifierRuntimeSearchEngine<User> usersSearchEngine = new UsersIdentifierRuntimeSearchEngine();
    private final RealmProvider realmProvider;
    private UserSystemManager userSystemManager;

    public WildflyUserFileSystemManager() {
        this(new ConfigProperties(System.getProperties()));
    }

    public WildflyUserFileSystemManager(Map<String, String> gitPrefs) {
        this(new ConfigProperties(gitPrefs));
    }

    public WildflyUserFileSystemManager(ConfigProperties gitPrefs) {
        this.realmProvider = new RealmProvider(gitPrefs);
    }

    public void initialize(UserSystemManager userSystemManager) {
        this.userSystemManager = userSystemManager;
    }

    protected synchronized WildflyGroupFileSystemManager getGroupsFileSystemManager() {
        try {
            return (WildflyGroupFileSystemManager)this.userSystemManager.groups();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void destroy() throws Exception {
    }

    public AbstractEntityManager.SearchResponse<User> search(AbstractEntityManager.SearchRequest request) throws SecurityManagementException {
        ArrayList<String> users = new ArrayList<String>();
        try {
            ModifiableRealmIdentityIterator realmIdentityIterator = this.realmProvider.getRealm().getRealmIdentityIterator();
            while (realmIdentityIterator.hasNext()) {
                ModifiableRealmIdentity next = (ModifiableRealmIdentity)realmIdentityIterator.next();
                users.add(next.getRealmIdentityPrincipal().getName());
            }
        }
        catch (RealmUnavailableException e) {
            throw new SecurityManagementException((Throwable)e);
        }
        return this.usersSearchEngine.searchByIdentifiers(users, request);
    }

    public User get(String identifier) throws SecurityManagementException {
        ModifiableRealmIdentity modifiableIdentity = this.realmProvider.getRealm().getRealmIdentityForUpdate((Principal)new NamePrincipal(identifier));
        try {
            Optional<User> user = this.getUser(modifiableIdentity);
            if (user.isPresent()) {
                return user.get();
            }
            throw new UserNotFoundException(identifier);
        }
        catch (RealmUnavailableException e) {
            throw new UserNotFoundException(identifier);
        }
    }

    public List<User> getAll() throws SecurityManagementException {
        ArrayList<User> result = new ArrayList<User>();
        try {
            ModifiableRealmIdentityIterator realmIdentityIterator = this.realmProvider.getRealm().getRealmIdentityIterator();
            while (realmIdentityIterator.hasNext()) {
                ModifiableRealmIdentity identity = (ModifiableRealmIdentity)realmIdentityIterator.next();
                Optional<User> user = this.getUser(identity);
                if (!user.isPresent()) continue;
                result.add(user.get());
            }
        }
        catch (RealmUnavailableException e) {
            throw new SecurityManagementException((Throwable)e);
        }
        return result;
    }

    private Optional<User> getUser(ModifiableRealmIdentity identity) throws RealmUnavailableException {
        Set<String> allGroups;
        String userName = identity.getRealmIdentityPrincipal().getName();
        Attributes attributes = identity.getAttributes();
        Attributes.Entry roles = attributes.get("role");
        HashSet<String> userGroups = new HashSet<String>();
        HashSet groups = new HashSet();
        for (String role : roles) {
            userGroups.add(role);
        }
        Set registeredRoles = SecurityManagementUtils.getRegisteredRoleNames();
        if (groups != null && (allGroups = this.getGroupsFileSystemManager().getAllGroups()) != null) {
            HashSet _groups = new HashSet();
            HashSet _roles = new HashSet();
            for (String name : userGroups) {
                if (!allGroups.contains(name)) {
                    String error = "Error getting groups for user. User's group '" + name + "' does not exist.";
                    LOG.error(error);
                    throw new SecurityManagementException(error);
                }
                SecurityManagementUtils.populateGroupOrRoles((String)name, (Set)registeredRoles, _groups, _roles);
            }
            return Optional.of(SecurityManagementUtils.createUser((String)userName, _groups, _roles));
        }
        return Optional.empty();
    }

    public User create(User entity) throws SecurityManagementException {
        Preconditions.checkNotNull((Object)"entity", (Object)entity);
        String username = entity.getIdentifier();
        if (null == username || 0 == username.trim().length()) {
            throw new IllegalArgumentException("No username specified.");
        }
        try {
            ModifiableRealmIdentity modifiableIdentity = this.realmProvider.getRealm().getRealmIdentityForUpdate((Principal)new NamePrincipal(username));
            if (!modifiableIdentity.exists()) {
                modifiableIdentity.create();
            }
        }
        catch (RealmUnavailableException e) {
            LOG.error("Error creating user " + username, (Throwable)e);
            throw new SecurityManagementException((Throwable)e);
        }
        return entity;
    }

    public User update(User entity) throws SecurityManagementException {
        Preconditions.checkNotNull((Object)"entity", (Object)entity);
        return entity;
    }

    public void delete(String ... usernames) throws SecurityManagementException {
        Preconditions.checkNotNull((Object)"usernames", (Object)usernames);
        for (String username : usernames) {
            ModifiableRealmIdentity identity = this.realmProvider.getRealm().getRealmIdentityForUpdate((Principal)new NamePrincipal(username));
            try {
                if (!identity.exists()) continue;
                identity.delete();
            }
            catch (RealmUnavailableException e) {
                throw new SecurityManagementException((Throwable)e);
            }
        }
    }

    public UserManagerSettings getSettings() {
        HashMap<Capability, CapabilityStatus> capabilityStatusMap = new HashMap<Capability, CapabilityStatus>(8);
        for (Capability capability : SecurityManagementUtils.USERS_CAPABILITIES) {
            capabilityStatusMap.put(capability, this.getCapabilityStatus(capability));
        }
        return new UserManagerSettingsImpl(capabilityStatusMap, null);
    }

    protected CapabilityStatus getCapabilityStatus(Capability capability) {
        if (capability != null) {
            switch (capability) {
                case CAN_SEARCH_USERS: 
                case CAN_ADD_USER: 
                case CAN_UPDATE_USER: 
                case CAN_DELETE_USER: 
                case CAN_READ_USER: 
                case CAN_ASSIGN_GROUPS: 
                case CAN_ASSIGN_ROLES: 
                case CAN_CHANGE_PASSWORD: {
                    return CapabilityStatus.ENABLED;
                }
            }
        }
        return CapabilityStatus.UNSUPPORTED;
    }

    public void assignGroups(String username, Collection<String> groups) throws SecurityManagementException {
        try {
            FileSystemSecurityRealm realm = this.realmProvider.getRealm();
            ModifiableRealmIdentity identity = realm.getRealmIdentityForUpdate((Principal)new NamePrincipal(username));
            MapAttributes attributes = new MapAttributes();
            Set userRoles = SecurityManagementUtils.rolesToString((Set)SecurityManagementUtils.getRoles((UserSystemManager)this.userSystemManager, (String)username));
            userRoles.addAll(groups);
            attributes.addAll("role", (Collection)userRoles);
            identity.setAttributes((Attributes)attributes);
            identity.dispose();
        }
        catch (RealmUnavailableException e) {
            throw new SecurityManagementException((Throwable)e);
        }
    }

    public void assignRoles(String username, Collection<String> roles) throws SecurityManagementException {
        try {
            FileSystemSecurityRealm realm = this.realmProvider.getRealm();
            ModifiableRealmIdentity identity = realm.getRealmIdentityForUpdate((Principal)new NamePrincipal(username));
            MapAttributes attributes = new MapAttributes();
            Set userGroups = SecurityManagementUtils.groupsToString((Set)SecurityManagementUtils.getGroups((UserSystemManager)this.userSystemManager, (String)username));
            userGroups.addAll(roles);
            attributes.addAll("role", (Collection)userGroups);
            identity.setAttributes((Attributes)attributes);
            identity.dispose();
        }
        catch (RealmUnavailableException e) {
            throw new SecurityManagementException((Throwable)e);
        }
    }

    public void changePassword(String username, String newPassword) throws SecurityManagementException {
        Preconditions.checkNotNull((Object)"username", (Object)username);
        if (0 == username.trim().length()) {
            throw new IllegalArgumentException("No username specified for updating password.");
        }
        try {
            ModifiableRealmIdentity modifiableIdentity = this.realmProvider.getRealm().getRealmIdentityForUpdate((Principal)new NamePrincipal(username));
            String TEST_REALM = "ApplicationRealm";
            PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"digest-md5", (Provider)ELYTRON_PROVIDER);
            DigestPasswordAlgorithmSpec digestAlgorithmSpec = new DigestPasswordAlgorithmSpec(username, "ApplicationRealm");
            EncryptablePasswordSpec encryptableSpec = new EncryptablePasswordSpec(newPassword.toCharArray(), (AlgorithmParameterSpec)digestAlgorithmSpec);
            DigestPassword original = (DigestPassword)passwordFactory.generatePassword((KeySpec)encryptableSpec);
            byte[] digest = original.getDigest();
            DigestPasswordSpec digestPasswordSpec = new DigestPasswordSpec(username, "ApplicationRealm", digest);
            DigestPassword restored = (DigestPassword)passwordFactory.generatePassword((KeySpec)digestPasswordSpec);
            modifiableIdentity.setCredentials(Collections.singleton(new PasswordCredential((Password)restored)));
            modifiableIdentity.dispose();
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            LOG.error("Error changing user's password", (Throwable)e);
            throw new SecurityManagementException((Throwable)e);
        }
    }
}

