/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.server;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.security.ResourceManager;
import org.uberfire.security.SecurityContext;
import org.uberfire.security.SecurityManager;
import org.uberfire.security.Subject;
import org.uberfire.security.auth.AuthenticationException;
import org.uberfire.security.auth.AuthenticationManager;
import org.uberfire.security.auth.AuthenticationProvider;
import org.uberfire.security.auth.AuthenticationScheme;
import org.uberfire.security.auth.RoleProvider;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.security.authz.ResourceDecisionManager;
import org.uberfire.security.authz.RoleDecisionManager;
import org.uberfire.security.authz.VotingStrategy;
import org.uberfire.security.impl.authz.ConsensusBasedVoter;
import org.uberfire.security.server.HttpSecurityManagerImpl;
import org.uberfire.security.server.URLResourceManager;
import org.uberfire.security.server.auth.CookieStorage;
import org.uberfire.security.server.auth.FormAuthenticationScheme;
import org.uberfire.security.server.auth.HttpSessionStorage;
import org.uberfire.security.server.auth.RememberMeCookieAuthScheme;
import org.uberfire.security.server.cdi.SecurityFactory;

public class UberFireSecurityFilter
implements Filter {
    private final Logger LOG = LoggerFactory.getLogger(UberFireSecurityFilter.class);
    private SecurityManager securityManager = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        Map<String, String> options = this.buildOptions(filterConfig);
        CookieStorage cookieStorage = this.getCookieStorage(options);
        RememberMeCookieAuthScheme rememberMeAuthScheme = new RememberMeCookieAuthScheme(cookieStorage);
        AuthenticationScheme authScheme = this.getAuthenticationScheme(options);
        AuthenticationManager authManager = this.getAuthenticationManager(options);
        AuthenticationProvider authProvider = this.getAuthenticationProvider(options);
        ResourceManager resourceManager = this.getResourceManager(options);
        AuthorizationManager authzManager = this.getAuthorizationManager(options);
        VotingStrategy urlVotingStrategy = this.getURLVotingStrategy(options);
        ResourceDecisionManager accessDecisionManager = this.getURLAccessDecisionManager(options);
        RoleDecisionManager roleDecisionManager = this.getRoleDecisionManager(options);
        RoleProvider roleProvider = this.getRoleProvider(options);
        this.securityManager = HttpSecurityManagerImpl.newBuilder().addAuthManager(authManager).addAuthScheme(rememberMeAuthScheme).addAuthScheme(authScheme).addAuthProvider(authProvider).addAuthenticatedStorageProvider(new HttpSessionStorage()).addAuthenticatedStorageProvider(cookieStorage).addRoleProvider(roleProvider).addAuthzManager(authzManager).addVotingStrategy(urlVotingStrategy).addAccessDecisionManager(accessDecisionManager).addResourceManager(resourceManager).addRoleDecisionManager(roleDecisionManager).loadAvailableAuthenticationSources().build(options);
        this.securityManager.start();
    }

    private Map<String, String> buildOptions(FilterConfig filterConfig) {
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration initParams = filterConfig.getInitParameterNames();
        while (initParams.hasMoreElements()) {
            String name = (String)initParams.nextElement();
            String value = filterConfig.getInitParameter(name);
            if (value.trim().isEmpty()) continue;
            result.put(name, value);
        }
        Enumeration servletInitParams = filterConfig.getServletContext().getInitParameterNames();
        while (servletInitParams.hasMoreElements()) {
            String name = (String)servletInitParams.nextElement();
            String value = filterConfig.getServletContext().getInitParameter(name);
            if (value.trim().isEmpty()) continue;
            result.put(name, value);
        }
        return result;
    }

    private CookieStorage getCookieStorage(Map<String, String> options) {
        String cookieName = options.get("org.uberfire.cookie.id");
        if (cookieName == null || cookieName.trim().isEmpty()) {
            throw new RuntimeException("Can't find cookie id.");
        }
        return new CookieStorage(cookieName);
    }

    private RoleProvider getRoleProvider(Map<String, String> options) {
        String roleProvider = options.get("org.uberfire.auth.provider.role");
        return this.loadConfigClazz(roleProvider, RoleProvider.class);
    }

    private RoleDecisionManager getRoleDecisionManager(Map<String, String> options) {
        String roleManager = options.get("org.uberfire.authz.role");
        return this.loadConfigClazz(roleManager, RoleDecisionManager.class);
    }

    private ResourceDecisionManager getURLAccessDecisionManager(Map<String, String> options) {
        String accessManager = options.get("org.uberfire.authz.access.url");
        return this.loadConfigClazz(accessManager, ResourceDecisionManager.class);
    }

    private VotingStrategy getURLVotingStrategy(Map<String, String> options) {
        String votingStrategy = options.get("org.uberfire.authz.voting.url");
        if (votingStrategy == null || votingStrategy.isEmpty()) {
            return new ConsensusBasedVoter();
        }
        return this.loadConfigClazz(votingStrategy, VotingStrategy.class);
    }

    private AuthorizationManager getAuthorizationManager(Map<String, String> options) {
        String autzhManager = options.get("org.uberfire.authz.manager");
        return this.loadConfigClazz(autzhManager, AuthorizationManager.class);
    }

    private ResourceManager getResourceManager(Map<String, String> options) {
        String resManager = options.get("org.uberfire.resource.manager");
        if (resManager == null || resManager.isEmpty()) {
            String configFile = options.get("org.uberfire.resource.manager.config");
            return new URLResourceManager(configFile);
        }
        return this.loadConfigClazz(resManager, ResourceManager.class);
    }

    private AuthenticationProvider getAuthenticationProvider(Map<String, String> options) {
        String authProvider = options.get("org.uberfire.auth.provider");
        return this.loadConfigClazz(authProvider, AuthenticationProvider.class);
    }

    private AuthenticationManager getAuthenticationManager(Map<String, String> options) {
        String authManager = options.get("org.uberfire.auth.manager");
        return this.loadConfigClazz(authManager, AuthenticationManager.class);
    }

    private AuthenticationScheme getAuthenticationScheme(Map<String, String> options) {
        String authScheme = options.get("org.uberfire.auth.scheme");
        if (authScheme == null || authScheme.isEmpty()) {
            return new FormAuthenticationScheme();
        }
        if (authScheme.equalsIgnoreCase("FORM")) {
            return new FormAuthenticationScheme();
        }
        return null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block3: {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            SecurityContext context = this.securityManager.newSecurityContext(new Object[]{httpRequest, httpResponse});
            try {
                this.logout(context, httpRequest, httpResponse);
                this.authenticate(context, httpResponse);
                this.authorize(context, httpResponse);
                if (!response.isCommitted()) {
                    chain.doFilter(request, response);
                }
            }
            catch (AuthenticationException e) {
                if (response.isCommitted()) break block3;
                throw new ServletException((Throwable)e);
            }
        }
    }

    private void logout(SecurityContext context, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        if (httpResponse.isCommitted()) {
            return;
        }
        if (this.isLogoutRequest(httpRequest)) {
            this.securityManager.logout(context);
            try {
                httpResponse.sendRedirect(this.getBaseUrl(httpRequest));
            }
            catch (IOException e) {
                this.LOG.error("Can't redirect. Message: " + e.toString());
            }
        }
    }

    private String getBaseUrl(HttpServletRequest request) {
        if (request.getServerPort() == 80 || request.getServerPort() == 443) {
            return request.getScheme() + "://" + request.getServerName() + request.getContextPath();
        }
        return request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
    }

    private boolean isLogoutRequest(HttpServletRequest request) {
        return request.getRequestURI().contains("/uf_logout");
    }

    private void authenticate(SecurityContext context, HttpServletResponse httpResponse) throws AuthenticationException {
        if (httpResponse.isCommitted()) {
            return;
        }
        Subject subject = this.securityManager.authenticate(context);
        SecurityFactory.setSubject(subject);
    }

    private void authorize(SecurityContext context, HttpServletResponse httpResponse) throws IOException {
        if (httpResponse.isCommitted()) {
            return;
        }
        boolean authorize = this.securityManager.authorize(context);
        if (!authorize && !httpResponse.isCommitted()) {
            httpResponse.sendError(403);
        }
    }

    private <T> T loadConfigClazz(String clazzName, Class<T> typeOf) {
        if (clazzName == null || clazzName.isEmpty()) {
            return null;
        }
        try {
            Class<T> clazz = Class.forName(clazzName);
            if (!clazz.isAssignableFrom(typeOf)) {
                this.LOG.error("Invalid class type '" + typeOf.getName() + "'");
                return null;
            }
            return typeOf.cast(clazz.newInstance());
        }
        catch (ClassNotFoundException e) {
            this.LOG.error("Class not found '" + clazzName + "'");
        }
        catch (InstantiationException e) {
            this.LOG.error("Can't instantiate class '" + clazzName + "'");
        }
        catch (IllegalAccessException e) {
            this.LOG.error("The following error ocurred. " + e.getMessage());
        }
        return null;
    }

    public void destroy() {
        this.securityManager.dispose();
    }
}

