/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.config;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.preferences.ApplicationPreferencesLoader;
import org.guvnor.common.services.backend.preferences.SystemPropertiesInitializer;
import org.guvnor.common.services.shared.config.AppConfigService;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.commons.services.cdi.ApplicationStarted;

@Service
@ApplicationScoped
public class AppConfigServiceImpl
implements AppConfigService {
    private Map<String, String> preferences;
    @Inject
    @Any
    private Instance<ApplicationPreferencesLoader> preferencesLoaders;
    @Inject
    @Any
    private Instance<SystemPropertiesInitializer> systemPropertiesInitializers;

    public void configureOnEvent(@Observes ApplicationStarted applicationStartedEvent) {
        this.loadPreferences();
    }

    public synchronized Map<String, String> loadPreferences() {
        try {
            if (this.preferences == null) {
                this.preferences = new HashMap<String, String>();
                if (this.preferencesLoaders != null) {
                    for (ApplicationPreferencesLoader loader : this.preferencesLoaders) {
                        this.preferences.putAll(loader.load());
                    }
                }
                if (this.systemPropertiesInitializers != null) {
                    for (SystemPropertiesInitializer initializer : this.systemPropertiesInitializers) {
                        initializer.setSystemProperties(this.preferences);
                    }
                }
            }
            return this.preferences;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public long getTimestamp() {
        return new Date().getTime();
    }
}

