/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.config;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.guvnor.common.services.backend.config.DefaultApplicationPreferencesLoader;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.preferences.ApplicationPreferencesLoader;
import org.guvnor.common.services.backend.preferences.SystemPropertiesInitializer;
import org.guvnor.common.services.shared.config.AppConfigService;
import org.jboss.errai.bus.server.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.services.cdi.ApplicationStarted;

@Service
@ApplicationScoped
public class AppConfigServiceImpl
implements AppConfigService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultApplicationPreferencesLoader.class);
    private Map<String, String> preferences;
    private Instance<ApplicationPreferencesLoader> preferencesLoaders;
    private Instance<SystemPropertiesInitializer> systemPropertiesInitializers;

    public AppConfigServiceImpl() {
    }

    @Inject
    public AppConfigServiceImpl(@Any Instance<ApplicationPreferencesLoader> preferencesLoaders, @Any Instance<SystemPropertiesInitializer> systemPropertiesInitializers) {
        this.preferencesLoaders = preferencesLoaders;
        this.systemPropertiesInitializers = systemPropertiesInitializers;
    }

    public void configureOnEvent(@Observes ApplicationStarted applicationStartedEvent) {
        this.loadPreferences();
    }

    public synchronized Map<String, String> loadPreferences() {
        try {
            if (this.preferences == null) {
                this.preferences = new HashMap<String, String>();
                this.loadPreferencesFromAllStores();
                this.loadSystemProperties();
                this.setupSystemPropertiesInitializers();
            }
            return this.preferences;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private void loadPreferencesFromAllStores() {
        if (this.preferencesLoaders != null) {
            for (ApplicationPreferencesLoader loader : this.preferencesLoaders) {
                this.preferences.putAll(loader.load());
            }
        }
    }

    private void loadSystemProperties() {
        for (Map.Entry<String, String> entry : this.preferences.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String newValue = System.getProperty(key, value);
            if (value == null || value.equals(newValue)) continue;
            logger.info("Overriding preference '" + key + "' to '" + newValue + "' based on system property value.");
            this.preferences.put(key, newValue);
        }
    }

    private void setupSystemPropertiesInitializers() {
        if (this.systemPropertiesInitializers != null) {
            for (SystemPropertiesInitializer initializer : this.systemPropertiesInitializers) {
                initializer.setSystemProperties(this.preferences);
            }
        }
    }

    public long getTimestamp() {
        return new Date().getTime();
    }
}

