/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.test;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.guvnor.common.services.backend.test.TestResultMessageAggregator;
import org.guvnor.common.services.shared.test.TestResultMessage;
import org.guvnor.common.services.shared.test.TestRunnerService;
import org.guvnor.common.services.shared.test.TestService;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
public class TestRunnerServiceImpl
implements TestRunnerService {
    private Event<TestResultMessage> defaultTestResultMessageEvent;
    private Instance<TestService> testServices;

    public TestRunnerServiceImpl() {
    }

    @Inject
    public TestRunnerServiceImpl(@Any Instance<TestService> testServices, Event<TestResultMessage> defaultTestResultMessageEvent) {
        this.testServices = testServices;
        this.defaultTestResultMessageEvent = defaultTestResultMessageEvent;
    }

    public void runAllTests(String identifier, Path path) {
        this.runAllTests(identifier, path, this.defaultTestResultMessageEvent);
    }

    public void runAllTests(String identifier, Path path, Event<TestResultMessage> customTestResultEvent) {
        TestResultMessageAggregator testResultEvent = new TestResultMessageAggregator();
        for (TestService testService : this.testServices) {
            for (TestResultMessage testResultMessage : testService.runAllTests(identifier, path)) {
                testResultEvent.add(testResultMessage);
            }
        }
        customTestResultEvent.fire((Object)testResultEvent.getSummary(identifier));
    }
}

