/*
 * Decompiled with CFR 0.152.
 */
package org.ext.uberfire.social.activities.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class SocialUser
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String userName;
    private String realName;
    private String email;
    private List<String> followersName = new ArrayList<String>();
    private List<String> followingName = new ArrayList<String>();

    public SocialUser() {
    }

    public SocialUser(String username) {
        this.userName = username;
        this.realName = "";
        this.email = "";
    }

    public SocialUser(String username, List<String> followersName, List<String> followingName) {
        this.userName = username;
        this.realName = "";
        this.email = "";
        this.followersName = followersName;
        this.followingName = followingName;
    }

    public SocialUser(String username, String realName, String email, List<String> followersName, List<String> followingName) {
        this.userName = username;
        this.realName = realName;
        this.email = email;
        this.followersName = followersName;
        this.followingName = followingName;
    }

    public void follow(SocialUser anotherUser) {
        if (this.validate(anotherUser)) {
            this.followingName.add(anotherUser.getUserName());
            anotherUser.addFollower(this);
        }
    }

    private boolean validate(SocialUser anotherUser) {
        return !this.equals(anotherUser) && !this.followingName.contains(anotherUser.getUserName());
    }

    public void unfollow(SocialUser anotherUser) {
        if (!this.equals(anotherUser)) {
            this.followingName.remove(anotherUser.getUserName());
            anotherUser.removeFollower(this);
        }
    }

    private void removeFollower(SocialUser socialUser) {
        this.followersName.remove(socialUser.getUserName());
    }

    private void addFollower(SocialUser socialUser) {
        this.followersName.add(socialUser.getUserName());
    }

    public List<String> getFollowersName() {
        if (this.followersName == null) {
            this.followersName = new ArrayList<String>();
        }
        return this.followersName;
    }

    public String getUserName() {
        return this.userName;
    }

    public List<String> getFollowingName() {
        if (this.followingName == null) {
            this.followingName = new ArrayList<String>();
        }
        return this.followingName;
    }

    public String toString() {
        return "SocialUser{userName='" + this.userName + '}';
    }

    public String getName() {
        return this.getRealName().isEmpty() ? this.getUserName() : this.getRealName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SocialUser)) {
            return false;
        }
        SocialUser that = (SocialUser)o;
        return !(this.userName != null ? !this.userName.equals(that.userName) : that.userName != null);
    }

    public int hashCode() {
        return this.userName != null ? this.userName.hashCode() : 0;
    }

    public String getEmail() {
        if (this.email == null) {
            return "";
        }
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getRealName() {
        return this.realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }
}

