/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.organizationalunit.config;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorage;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageBatch;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.organizationalunit.config.SpaceInfo;
import org.kie.soup.commons.validation.PortablePreconditions;

@ApplicationScoped
public class SpaceConfigStorageRegistryImpl
implements SpaceConfigStorageRegistry {
    private Instance<SpaceConfigStorage> spaceConfigStorages;
    private Map<String, SpaceConfigStorage> storageBySpaceName = new ConcurrentHashMap<String, SpaceConfigStorage>();

    public SpaceConfigStorageRegistryImpl() {
    }

    @Inject
    public SpaceConfigStorageRegistryImpl(Instance<SpaceConfigStorage> spaceConfigStorages) {
        this.spaceConfigStorages = spaceConfigStorages;
    }

    public SpaceConfigStorage get(String spaceName) {
        return this.storageBySpaceName.computeIfAbsent(spaceName, name -> {
            SpaceConfigStorage spaceConfigStorage = (SpaceConfigStorage)this.spaceConfigStorages.get();
            spaceConfigStorage.setup(spaceName);
            return spaceConfigStorage;
        });
    }

    public SpaceConfigStorageBatch getBatch(String spaceName) {
        Optional<SpaceConfigStorage> optional = Optional.ofNullable(this.get(spaceName));
        if (optional.isPresent()) {
            return new SpaceStorageBatchImpl(optional.get());
        }
        throw new IllegalArgumentException("Cannot find Space '" + spaceName + "'");
    }

    public void remove(String spaceName) {
        if (this.exist(spaceName)) {
            this.storageBySpaceName.get(spaceName).close();
            this.storageBySpaceName.remove(spaceName);
        }
    }

    public boolean exist(String spaceName) {
        return this.storageBySpaceName.containsKey(spaceName);
    }

    private static class SpaceConfigStorageBatchContextImpl
    implements SpaceConfigStorageBatch.SpaceConfigStorageBatchContext {
        private SpaceConfigStorage spaceConfigStorage;
        private SpaceInfo info;

        public SpaceConfigStorageBatchContextImpl(SpaceConfigStorage spaceConfigStorage) {
            this.spaceConfigStorage = spaceConfigStorage;
            this.info = spaceConfigStorage.loadSpaceInfo();
        }

        public SpaceInfo getSpaceInfo() {
            return this.info;
        }

        public void saveSpaceInfo() {
            this.spaceConfigStorage.saveSpaceInfo(this.info);
        }
    }

    public static class SpaceStorageBatchImpl
    implements SpaceConfigStorageBatch {
        private SpaceConfigStorage spaceConfigStorage;

        public SpaceStorageBatchImpl(SpaceConfigStorage spaceConfigStorage) {
            this.spaceConfigStorage = spaceConfigStorage;
        }

        public <T> T run(Function<SpaceConfigStorageBatch.SpaceConfigStorageBatchContext, T> function) {
            PortablePreconditions.checkNotNull((String)"function", function);
            try {
                this.spaceConfigStorage.startBatch();
                T t = function.apply(new SpaceConfigStorageBatchContextImpl(this.spaceConfigStorage));
                return t;
            }
            finally {
                this.spaceConfigStorage.endBatch();
            }
        }
    }
}

