/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.structure.backend.repositories.ConfiguredRepositories;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.java.nio.file.api.FileSystemUtils;

@ApplicationScoped
@Startup
public class LoadReposOnAppInit {
    private ConfiguredRepositories configuredRepositories;
    private OrganizationalUnitService organizationalUnitService;

    public LoadReposOnAppInit() {
    }

    @Inject
    public LoadReposOnAppInit(ConfiguredRepositories configuredRepositories, OrganizationalUnitService organizationalUnitService) {
        this.configuredRepositories = configuredRepositories;
        this.organizationalUnitService = organizationalUnitService;
    }

    @PostConstruct
    public void execute() {
        if (this.isGitDefaultFileSystem()) {
            this.organizationalUnitService.getAllOrganizationalUnits().forEach(ou -> this.configuredRepositories.getAllConfiguredRepositories(ou.getSpace()));
        }
    }

    protected boolean isGitDefaultFileSystem() {
        return FileSystemUtils.isGitDefaultFileSystem();
    }
}

