/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.pom;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import org.guvnor.structure.backend.pom.DependencyTypesMapper;
import org.guvnor.structure.backend.pom.PomEditor;
import org.guvnor.structure.backend.pom.PomEditorDefault;
import org.guvnor.structure.pom.AddPomDependencyEvent;
import org.guvnor.structure.pom.DependencyType;
import org.guvnor.structure.pom.DynamicPomDependency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
public class PomStructureEditor {
    private final Logger logger = LoggerFactory.getLogger(PomStructureEditor.class);
    private PomEditor pomEditor = new PomEditorDefault();
    private DependencyTypesMapper mapper = new DependencyTypesMapper();

    public void onNewDynamicDependency(@Observes AddPomDependencyEvent event) {
        Path projectPath = event.getProjectPath();
        DependencyType dependencyType = event.getDependencyType();
        this.addDependenciesToPom(projectPath, this.mapper.getDependencies(dependencyType));
    }

    private void addDependenciesToPom(Path projectPath, List<DynamicPomDependency> deps) {
        if (!this.pomEditor.addDependencies(deps, projectPath)) {
            this.logger.warn("Failed to add dependencies {} to pom.xml located in {}", deps, (Object)projectPath);
        }
    }
}

