/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.structure.backend.repositories.ConfiguredRepositories;
import org.guvnor.structure.backend.repositories.SystemRepository;
import org.guvnor.structure.organizationalunit.config.RepositoryInfo;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.server.repositories.RepositoryFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.spaces.Space;

@ApplicationScoped
public class ConfiguredRepositoriesImpl
implements ConfiguredRepositories {
    private RepositoryFactory repositoryFactory;
    private SpaceConfigStorageRegistry spaceConfigStorage;

    public ConfiguredRepositoriesImpl() {
    }

    @Inject
    public ConfiguredRepositoriesImpl(RepositoryFactory repositoryFactory, SpaceConfigStorageRegistry spaceConfigStorage) {
        this.repositoryFactory = repositoryFactory;
        this.spaceConfigStorage = spaceConfigStorage;
    }

    @Override
    public Repository getRepositoryByRepositoryAlias(Space space, String alias) {
        return this.getRepositoryByRepositoryAlias(space, alias, false);
    }

    @Override
    public Repository getRepositoryByRepositoryAlias(Space space, String alias, boolean includeDeleted) {
        List<RepositoryInfo> repositories = this.getAllRepositoryInfo(space);
        return repositories.stream().filter(this.getRepository(alias, includeDeleted)).findAny().map(repo -> this.repositoryFactory.newRepository(repo)).orElse(null);
    }

    private List<RepositoryInfo> getAllRepositoryInfo(Space space) {
        try {
            return this.spaceConfigStorage.get(space.getName()).loadSpaceInfo().getRepositories();
        }
        catch (Exception e) {
            return new ArrayList<RepositoryInfo>();
        }
    }

    private Predicate<RepositoryInfo> getRepository(String alias, boolean includeDeleted) {
        return repositoryInfo -> repositoryInfo.getName().equals(alias) && (!repositoryInfo.isDeleted() || includeDeleted);
    }

    @Override
    public Repository getRepositoryByRootPath(Space space, Path root) {
        return this.getAllConfiguredRepositories(space).stream().filter(r -> {
            if (r.getBranches() != null) {
                for (Branch branch : r.getBranches()) {
                    Path rootPath = Paths.normalizePath((Path)branch.getPath());
                    if (!root.equals(rootPath)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }).findFirst().orElse(null);
    }

    @Override
    public List<Repository> getAllConfiguredRepositories(Space space) {
        return this.getConfiguredRepositories(space, repositoryInfo -> !repositoryInfo.isDeleted());
    }

    @Override
    public List<Repository> getAllConfiguredRepositories(Space space, boolean includeDeleted) {
        return this.getConfiguredRepositories(space, r -> includeDeleted || !r.isDeleted());
    }

    @Override
    public List<Repository> getAllDeletedConfiguredRepositories(Space space) {
        return this.getConfiguredRepositories(space, repositoryInfo -> repositoryInfo.isDeleted());
    }

    private List<Repository> getConfiguredRepositories(Space space, Predicate<RepositoryInfo> predicate) {
        List<RepositoryInfo> repositories = this.getAllRepositoryInfo(space);
        return repositories.stream().filter(predicate).map(repo -> this.repositoryFactory.newRepository(repo)).collect(Collectors.toList());
    }

    @Override
    public boolean containsAlias(Space space, String alias) {
        List<RepositoryInfo> repositories = this.getAllRepositoryInfo(space);
        return repositories.stream().anyMatch(r -> !r.isDeleted() && r.getName().equals(alias)) && SystemRepository.SYSTEM_REPO.getAlias().equals(alias);
    }
}

