/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.test;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.fs.file.SimpleFileSystemProvider;

public class CDITestSetup {
    public final SimpleFileSystemProvider fileSystemProvider = new SimpleFileSystemProvider();
    public BeanManager beanManager;
    public Paths paths;
    private Weld weld;

    public void setUp() throws Exception {
        this.weld = new Weld();
        WeldContainer weldContainer = this.weld.initialize();
        this.beanManager = weldContainer.getBeanManager();
        this.paths = this.getReference(Paths.class);
    }

    public void cleanup() {
        if (this.weld != null) {
            try {
                this.weld.shutdown();
            }
            catch (NullPointerException npeException) {
                LoggerFactory.getLogger(CDITestSetup.class).warn("Problem occured during weld clean up: " + npeException.getMessage());
            }
        }
    }

    public <T> T getReference(Class<T> clazz) {
        Bean bean = (Bean)this.beanManager.getBeans(clazz, new Annotation[0]).iterator().next();
        CreationalContext cc = this.beanManager.createCreationalContext((Contextual)bean);
        return (T)this.beanManager.getReference(bean, clazz, cc);
    }
}

