/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.mocks;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.uberfire.io.IOService;
import org.uberfire.io.impl.IOServiceDotFileImpl;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.api.FileSystemProviders;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;

public class FileSystemTestingUtils {
    private File path;
    private FileSystem fileSystem;
    private IOService ioService;

    public void setup() throws IOException {
        this.ioService = new IOServiceDotFileImpl();
        this.createTempDirectory();
        this.setupJGitRepository();
    }

    private void createTempDirectory() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        this.path = temp;
    }

    private void setupJGitRepository() {
        System.setProperty("org.uberfire.nio.git.dir", this.path.getAbsolutePath());
        URI newRepo = URI.create("git://amend-repo-test");
        this.fileSystem = this.ioService.newFileSystem(newRepo, new HashMap());
        Path init = this.ioService.get(URI.create("git://amend-repo-test/init.file"));
        this.ioService.write(init, "setupFS!", new OpenOption[0]);
    }

    public void cleanup() {
        FileUtils.deleteQuietly((File)this.path);
        JGitFileSystemProvider gitFsProvider = (JGitFileSystemProvider)FileSystemProviders.resolveProvider((URI)URI.create("git://whatever"));
        gitFsProvider.shutdown();
        FileUtils.deleteQuietly((File)gitFsProvider.getGitRepoContainerDir());
        gitFsProvider.rescanForExistingRepositories();
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public IOService getIoService() {
        return this.ioService;
    }
}

