/*
 * Copyright 2012 JBoss by Red Hat.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.uberfire.ext.widgets.common.client.forms;

import java.util.Map;

//This class is not @Portable since we only want it client-side
public class GetFormParamsEvent {

    private String action;
    private Map<String, Object> params;

    public GetFormParamsEvent() {
    }

    public GetFormParamsEvent( String action,
                               Map<String, Object> params ) {
        this.action = action;
        this.params = params;
    }

    public Map<String, Object> getParams() {
        return params;
    }

    public String getAction() {
        return action;
    }

}
