/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.tables;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.DataGrid;
import com.github.gwtbootstrap.client.ui.Label;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.cellview.client.RowStyles;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.Range;
import com.google.gwt.view.client.RangeChangeEvent;
import com.google.gwt.view.client.RowCountChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.List;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.ext.services.shared.preferences.GridColumnPreference;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.UserPreference;
import org.uberfire.ext.services.shared.preferences.UserPreferencesService;
import org.uberfire.ext.services.shared.preferences.UserPreferencesType;
import org.uberfire.ext.widgets.common.client.resources.CommonResources;
import org.uberfire.ext.widgets.common.client.tables.ColumnChangedHandler;
import org.uberfire.ext.widgets.common.client.tables.ColumnMeta;
import org.uberfire.ext.widgets.common.client.tables.ColumnPicker;
import org.uberfire.ext.widgets.common.client.tables.ResizableMovableHeader;

public class SimpleTable<T>
extends Composite
implements HasData<T> {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    @UiField(provided=true)
    public Button columnPickerButton;
    @UiField(provided=true)
    public DataGrid<T> dataGrid;
    @UiField
    public HorizontalPanel toolbarContainer;
    @UiField
    public HorizontalPanel rightToolbar;
    @UiField
    public FlowPanel rightActionsToolbar;
    @UiField
    public FlowPanel leftToolbar;
    @UiField
    public FlowPanel centerToolbar;
    private String emptyTableCaption;
    private ColumnPicker<T> columnPicker;
    private GridPreferencesStore gridPreferencesStore;
    @Inject
    private Caller<UserPreferencesService> preferencesService;
    @Inject
    private User identity;
    private ProvidesKey<T> providersKey;

    public SimpleTable() {
        this.dataGrid = new DataGrid();
        this.setupGridTable();
    }

    public SimpleTable(ProvidesKey<T> providesKey, GridGlobalPreferences gridGlobalPreferences) {
        this.dataGrid = new DataGrid(Integer.MAX_VALUE, providesKey);
        this.gridPreferencesStore = new GridPreferencesStore(gridGlobalPreferences);
        this.setupGridTable();
    }

    public SimpleTable(ProvidesKey<T> providesKey) {
        this.dataGrid = new DataGrid(Integer.MAX_VALUE, providesKey);
        this.setupGridTable();
    }

    private void setupGridTable() {
        this.dataGrid.setStriped(true);
        this.dataGrid.setBordered(true);
        this.dataGrid.setSkipRowHoverCheck(false);
        this.dataGrid.setSkipRowHoverStyleUpdate(false);
        this.dataGrid.setWidth("100%");
        this.dataGrid.setHeight("300px");
        this.dataGrid.addStyleName(CommonResources.INSTANCE.CSS().dataGrid());
        this.setEmptyTableWidget();
        this.columnPicker = new ColumnPicker<T>(this.dataGrid, this.gridPreferencesStore);
        this.columnPicker.addColumnChangedHandler(new ColumnChangedHandler(){

            @Override
            public void beforeColumnChanged() {
            }

            @Override
            public void afterColumnChanged() {
                if (SimpleTable.this.gridPreferencesStore != null && SimpleTable.this.preferencesService != null) {
                    List<GridColumnPreference> columnsState = SimpleTable.this.columnPicker.getColumnsState();
                    SimpleTable.this.gridPreferencesStore.resetGridColumnPreferences();
                    for (GridColumnPreference gcp : columnsState) {
                        SimpleTable.this.gridPreferencesStore.addGridColumnPreference(gcp);
                    }
                    SimpleTable.this.saveGridPreferences();
                }
            }
        });
        this.columnPickerButton = this.columnPicker.createToggleButton();
        this.initWidget(this.makeWidget());
    }

    protected Widget makeWidget() {
        return (Widget)uiBinder.createAndBindUi((Object)this);
    }

    public void setEmptyTableCaption(String emptyTableCaption) {
        this.emptyTableCaption = emptyTableCaption;
        this.setEmptyTableWidget();
    }

    private void setEmptyTableWidget() {
        String caption = "-----";
        if (this.emptyTableCaption != null && !this.emptyTableCaption.trim().isEmpty()) {
            caption = this.emptyTableCaption;
        }
        this.dataGrid.setEmptyTableWidget((Widget)new Label(caption));
    }

    public void redraw() {
        this.dataGrid.redraw();
    }

    public void refresh() {
        this.dataGrid.setVisibleRangeAndClearData(this.dataGrid.getVisibleRange(), true);
    }

    public HandlerRegistration addCellPreviewHandler(CellPreviewEvent.Handler<T> handler) {
        return this.dataGrid.addCellPreviewHandler(handler);
    }

    public HandlerRegistration addRangeChangeHandler(RangeChangeEvent.Handler handler) {
        return this.dataGrid.addRangeChangeHandler(handler);
    }

    public HandlerRegistration addRowCountChangeHandler(RowCountChangeEvent.Handler handler) {
        return this.dataGrid.addRowCountChangeHandler(handler);
    }

    public int getColumnIndex(Column<T, ?> column) {
        return this.dataGrid.getColumnIndex(column);
    }

    public HandlerRegistration addColumnSortHandler(ColumnSortEvent.Handler handler) {
        return this.dataGrid.addColumnSortHandler(handler);
    }

    public int getRowCount() {
        return this.dataGrid.getRowCount();
    }

    public Range getVisibleRange() {
        return this.dataGrid.getVisibleRange();
    }

    public boolean isRowCountExact() {
        return this.dataGrid.isRowCountExact();
    }

    public void setRowCount(int count) {
        this.dataGrid.setRowCount(count);
    }

    public void setRowCount(int count, boolean isExact) {
        this.dataGrid.setRowCount(count, isExact);
    }

    public void setVisibleRange(int start, int length) {
        this.dataGrid.setVisibleRange(start, length);
    }

    public void setVisibleRange(Range range) {
        this.dataGrid.setVisibleRange(range);
    }

    public void setPreferencesService(Caller<UserPreferencesService> preferencesService) {
        this.preferencesService = preferencesService;
    }

    public SelectionModel<? super T> getSelectionModel() {
        return this.dataGrid.getSelectionModel();
    }

    public T getVisibleItem(int indexOnPage) {
        return (T)this.dataGrid.getVisibleItem(indexOnPage);
    }

    public int getVisibleItemCount() {
        return this.dataGrid.getVisibleItemCount();
    }

    public Iterable<T> getVisibleItems() {
        return this.dataGrid.getVisibleItems();
    }

    public void setRowData(int start, List<? extends T> values) {
        this.dataGrid.setRowData(start, values);
    }

    public void setRowData(List<? extends T> values) {
        this.dataGrid.setRowData(values);
    }

    public void setSelectionModel(SelectionModel<? super T> selectionModel) {
        this.dataGrid.setSelectionModel(selectionModel);
    }

    public void setSelectionModel(SelectionModel<? super T> selectionModel, CellPreviewEvent.Handler<T> selectionEventManager) {
        this.dataGrid.setSelectionModel(selectionModel, selectionEventManager);
    }

    public void setVisibleRangeAndClearData(Range range, boolean forceRangeChangeEvent) {
        this.dataGrid.setVisibleRangeAndClearData(range, forceRangeChangeEvent);
    }

    public void addColumns(List<ColumnMeta<T>> columnMetas) {
        for (ColumnMeta<T> columnMeta : columnMetas) {
            if (columnMeta.getHeader() != null) continue;
            columnMeta.setHeader(this.getColumnHeader(columnMeta.getCaption(), columnMeta.getColumn()));
        }
        this.columnPicker.addColumns(columnMetas);
    }

    public void addColumn(Column<T, ?> column, String caption) {
        this.addColumn(column, caption, true);
    }

    public void addColumn(Column<T, ?> column, String caption, boolean visible) {
        ColumnMeta<T> columnMeta = new ColumnMeta<T>(column, caption, visible);
        this.addColumn(columnMeta);
    }

    protected void addColumn(ColumnMeta<T> columnMeta) {
        if (columnMeta.getHeader() == null) {
            columnMeta.setHeader(this.getColumnHeader(columnMeta.getCaption(), columnMeta.getColumn()));
        }
        this.columnPicker.addColumn(columnMeta);
    }

    protected ResizableMovableHeader<T> getColumnHeader(String caption, Column column) {
        ResizableMovableHeader header = new ResizableMovableHeader<T>(caption, this.dataGrid, this.columnPicker, column){

            @Override
            protected int getTableBodyHeight() {
                return SimpleTable.this.dataGrid.getOffsetHeight();
            }
        };
        header.addColumnChangedHandler(new ColumnChangedHandler(){

            @Override
            public void afterColumnChanged() {
                if (SimpleTable.this.gridPreferencesStore != null && SimpleTable.this.preferencesService != null) {
                    List<GridColumnPreference> columnsState = SimpleTable.this.columnPicker.getColumnsState();
                    SimpleTable.this.gridPreferencesStore.resetGridColumnPreferences();
                    for (GridColumnPreference gcp : columnsState) {
                        SimpleTable.this.gridPreferencesStore.addGridColumnPreference(gcp);
                    }
                    SimpleTable.this.saveGridPreferences();
                }
            }

            @Override
            public void beforeColumnChanged() {
            }
        });
        return header;
    }

    public void setColumnWidth(Column<T, ?> column, double width, Style.Unit unit) {
        this.dataGrid.setColumnWidth(column, width, unit);
    }

    public void setHeight(String height) {
        this.dataGrid.setHeight(height);
    }

    public void setPixelSize(int width, int height) {
        this.dataGrid.setPixelSize(width, height);
    }

    public void setSize(String width, String height) {
        this.dataGrid.setSize(width, height);
    }

    public void setWidth(String width) {
        this.dataGrid.setWidth(width);
    }

    public void setToolBarVisible(boolean visible) {
        this.toolbarContainer.setVisible(visible);
    }

    public ColumnSortList getColumnSortList() {
        return this.dataGrid.getColumnSortList();
    }

    public HasWidgets getToolbar() {
        return this.toolbarContainer;
    }

    public HasWidgets getRightToolbar() {
        return this.rightToolbar;
    }

    public HasWidgets getRightActionsToolbar() {
        return this.rightActionsToolbar;
    }

    public HasWidgets getLeftToolbar() {
        return this.leftToolbar;
    }

    public HasWidgets getCenterToolbar() {
        return this.centerToolbar;
    }

    public void setRowStyles(RowStyles<T> styles) {
        this.dataGrid.setRowStyles(styles);
    }

    public void setGridPreferencesStore(GridPreferencesStore gridPreferences) {
        this.gridPreferencesStore = gridPreferences;
        this.columnPicker.setGridPreferencesStore(gridPreferences);
    }

    public GridPreferencesStore getGridPreferencesStore() {
        return this.gridPreferencesStore;
    }

    public void saveGridPreferences() {
        if (this.gridPreferencesStore != null && this.preferencesService != null) {
            this.gridPreferencesStore.setPreferenceKey(this.gridPreferencesStore.getGlobalPreferences().getKey());
            this.gridPreferencesStore.setType(UserPreferencesType.GRIDPREFERENCES);
            ((UserPreferencesService)this.preferencesService.call((RemoteCallback)new RemoteCallback<Void>(){

                public void callback(Void response) {
                }
            })).saveUserPreferences((UserPreference)this.gridPreferencesStore);
        }
    }

    public void addTableTitle(String tableTitle) {
        this.getLeftToolbar().add((Widget)new HTML("<h4>" + tableTitle + "</h4>"));
    }

    public void setcolumnPickerButtonVisibe(boolean show) {
        this.columnPickerButton.setVisible(show);
    }

    static interface Binder
    extends UiBinder<Widget, SimpleTable> {
    }
}

