/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.common;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.DecoratedPopupPanel;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.ui.html.Span;
import org.uberfire.ext.widgets.common.client.animations.LinearFadeInAnimation;
import org.uberfire.ext.widgets.common.client.animations.LinearFadeOutAnimation;

public class BusyPopup
extends DecoratedPopupPanel {
    private static LoadingViewBinder uiBinder = (LoadingViewBinder)GWT.create(LoadingViewBinder.class);
    private static Timer deferredShowTimer = new Timer(){

        public void run() {
            fadeInAnimation.run(250);
        }
    };
    private static MessageState state = MessageState.DORMANT;
    @UiField
    Span message;
    private static final BusyPopup INSTANCE = new BusyPopup();
    private static final LinearFadeInAnimation fadeInAnimation = new LinearFadeInAnimation((Widget)INSTANCE){

        @Override
        public void onStart() {
            state = MessageState.SHOWING;
            INSTANCE.center();
            super.onStart();
        }

        @Override
        public void onComplete() {
            state = MessageState.VISIBLE;
            super.onComplete();
        }
    };
    private static final LinearFadeOutAnimation fadeOutAnimation = new LinearFadeOutAnimation((Widget)INSTANCE){

        @Override
        public void onStart() {
            state = MessageState.HIDING;
            super.onStart();
        }

        @Override
        public void onComplete() {
            state = MessageState.DORMANT;
            INSTANCE.hide();
            super.onComplete();
        }
    };

    private BusyPopup() {
        this.setWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.getElement().getStyle().setZIndex(Integer.MAX_VALUE);
        this.setGlassEnabled(true);
    }

    public static void showMessage(String message) {
        switch (state) {
            case DORMANT: {
                BusyPopup.INSTANCE.message.setText(message);
                deferredShowTimer.schedule(250);
                state = MessageState.PENDING;
                break;
            }
            case PENDING: 
            case SHOWING: 
            case VISIBLE: {
                BusyPopup.INSTANCE.message.setText(message);
                break;
            }
            case HIDING: {
                fadeOutAnimation.cancel();
                BusyPopup.INSTANCE.message.setText(message);
                fadeInAnimation.onComplete();
            }
        }
    }

    public static void close() {
        switch (state) {
            case DORMANT: {
                break;
            }
            case PENDING: {
                deferredShowTimer.cancel();
                state = MessageState.DORMANT;
                break;
            }
            case SHOWING: {
                fadeInAnimation.cancel();
                fadeOutAnimation.run(250);
                break;
            }
            case VISIBLE: {
                fadeOutAnimation.run(250);
                break;
            }
        }
    }

    private static enum MessageState {
        DORMANT,
        PENDING,
        SHOWING,
        VISIBLE,
        HIDING;

    }

    static interface LoadingViewBinder
    extends UiBinder<Widget, BusyPopup> {
    }
}

