/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.common;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.ui.Input;
import org.gwtbootstrap3.client.ui.InputGroupAddon;
import org.uberfire.mvp.Command;

public class FileUpload
extends Composite {
    private static final String FAKEPATH = "c:\\fakepath\\";
    private final Command command;
    @UiField
    InputGroupAddon uploadButton;
    @UiField
    InputGroupAddon chooseButton;
    @UiField
    Input file;
    @UiField
    Input fileText;
    private boolean isDisabled = false;
    private static FileUploadBinder uiBinder = (FileUploadBinder)GWT.create(FileUploadBinder.class);

    public FileUpload() {
        this(null, false);
    }

    public FileUpload(Command command) {
        this(command, true);
    }

    public FileUpload(final Command command, boolean displayUploadButton) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.command = command;
        this.fileText.setReadOnly(true);
        this.file.addChangeHandler(this.getFileChangeHandler());
        this.chooseButton.addDomHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                ((InputElement)FileUpload.this.file.getElement().cast()).click();
            }
        }, ClickEvent.getType());
        if (displayUploadButton) {
            this.uploadButton.addDomHandler((EventHandler)new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (FileUpload.this.isDisabled) {
                        return;
                    }
                    if (command != null) {
                        command.execute();
                    }
                }
            }, ClickEvent.getType());
        } else {
            this.uploadButton.removeFromParent();
            this.uploadButton = null;
        }
    }

    public void setName(String name) {
        this.file.setName(name);
    }

    public void upload() {
        this.command.execute();
    }

    public String getFilename() {
        return (String)this.file.getValue();
    }

    public void setEnabled(boolean b) {
        if (this.uploadButton == null) {
            return;
        }
        if (!b) {
            this.isDisabled = true;
            this.uploadButton.addStyleName("disabled");
        } else {
            this.isDisabled = false;
            this.uploadButton.removeStyleName("disabled");
        }
    }

    protected ChangeHandler getFileChangeHandler() {
        return new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                String fileName = (String)FileUpload.this.file.getValue();
                if (fileName.toLowerCase().startsWith(FileUpload.FAKEPATH)) {
                    fileName = fileName.substring(FileUpload.FAKEPATH.length());
                }
                FileUpload.this.fileText.setValue((Object)fileName);
            }
        };
    }

    static interface FileUploadBinder
    extends UiBinder<Widget, FileUpload> {
    }
}

