/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.common;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasCloseHandlers;
import com.google.gwt.event.logical.shared.HasOpenHandlers;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import org.uberfire.ext.widgets.common.client.common.AbstractLazyStackPanelHeader;
import org.uberfire.ext.widgets.common.client.resources.CommonImages;

public class LazyStackPanelHeader
extends AbstractLazyStackPanelHeader {
    private static LazyStackPanelHeaderBinder uiBinder = (LazyStackPanelHeaderBinder)GWT.create(LazyStackPanelHeaderBinder.class);
    @UiField
    Image icon;
    @UiField
    HorizontalPanel container;
    private ClickHandler expandClickHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            LazyStackPanelHeader.this.onTitleClicked();
        }
    };

    public LazyStackPanelHeader(String headerText, ImageResource headerIcon) {
        this(headerText, new Image(headerIcon));
    }

    public LazyStackPanelHeader(String headerText, Image headerIcon) {
        this();
        Image titleIcon = headerIcon;
        this.container.add((Widget)titleIcon);
        Label titleLabel = new Label(headerText);
        titleLabel.setStyleName("guvnor-cursor");
        titleLabel.addClickHandler(this.expandClickHandler);
        this.container.add((Widget)titleLabel);
    }

    public LazyStackPanelHeader(String headerText) {
        this();
        Label titleLabel = new Label(headerText);
        titleLabel.setStyleName("guvnor-cursor");
        titleLabel.addClickHandler(this.expandClickHandler);
        this.container.add((Widget)titleLabel);
    }

    public LazyStackPanelHeader() {
        this.add((Widget)uiBinder.createAndBindUi((Object)this));
        this.icon.addClickHandler(this.expandClickHandler);
        this.setIconImage();
        this.addOpenHandler(new OpenHandler<AbstractLazyStackPanelHeader>(){

            public void onOpen(OpenEvent<AbstractLazyStackPanelHeader> event) {
                LazyStackPanelHeader.this.expanded = true;
                LazyStackPanelHeader.this.setIconImage();
            }
        });
        this.addCloseHandler(new CloseHandler<AbstractLazyStackPanelHeader>(){

            public void onClose(CloseEvent<AbstractLazyStackPanelHeader> event) {
                LazyStackPanelHeader.this.expanded = false;
                LazyStackPanelHeader.this.setIconImage();
            }
        });
    }

    @Override
    public void expand() {
        if (!this.expanded) {
            this.onTitleClicked();
        }
    }

    @Override
    public void collapse() {
        if (this.expanded) {
            this.onTitleClicked();
        }
    }

    private void setIconImage() {
        if (this.expanded) {
            this.icon.setResource(CommonImages.INSTANCE.collapse());
        } else {
            this.icon.setResource(CommonImages.INSTANCE.expand());
        }
    }

    private void onTitleClicked() {
        if (this.expanded) {
            CloseEvent.fire((HasCloseHandlers)this, (Object)((Object)this));
        } else {
            OpenEvent.fire((HasOpenHandlers)this, (Object)((Object)this));
        }
    }

    static interface LazyStackPanelHeaderBinder
    extends UiBinder<Widget, LazyStackPanelHeader> {
    }
}

