/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.tables;

import com.google.gwt.cell.client.AbstractSafeHtmlCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.text.shared.SafeHtmlRenderer;
import org.uberfire.ext.widgets.common.client.resources.CommonCss;
import org.uberfire.ext.widgets.common.client.resources.CommonResources;

public class TitledTextCell
extends AbstractSafeHtmlCell<TitledText> {
    protected static final CommonCss css = CommonResources.INSTANCE.CSS();

    public TitledTextCell() {
        super((SafeHtmlRenderer)TitledTextSafeHtmlRenderer.getInstance(), new String[0]);
    }

    public TitledTextCell(SafeHtmlRenderer<TitledText> renderer) {
        super(renderer, new String[0]);
    }

    public void render(Cell.Context context, SafeHtml value, SafeHtmlBuilder sb) {
        if (value != null) {
            sb.append(value);
        }
    }

    public static class TitledTextSafeHtmlRenderer
    implements SafeHtmlRenderer<TitledText> {
        private static TitledTextSafeHtmlRenderer instance;

        public static TitledTextSafeHtmlRenderer getInstance() {
            if (instance == null) {
                instance = new TitledTextSafeHtmlRenderer();
            }
            return instance;
        }

        private TitledTextSafeHtmlRenderer() {
        }

        public SafeHtml render(TitledText object) {
            boolean bHasDescription;
            boolean bl = bHasDescription = object.description != null && !"".equals(object.description);
            if (bHasDescription) {
                String html = "<div class='" + css.titleTextCellContainer() + "'>";
                html = html + "<div>" + object.title + "</div>";
                html = html + "<div class='" + css.titleTextCellDescription() + "'>" + object.description + "</div>";
                html = html + "</div>";
                return SafeHtmlUtils.fromTrustedString((String)html);
            }
            String html = "<div class='" + css.titleTextCellContainer() + "'>";
            html = html + "<div>" + object.title + "</div>";
            html = html + "</div>";
            return SafeHtmlUtils.fromTrustedString((String)html);
        }

        public void render(TitledText object, SafeHtmlBuilder builder) {
            builder.append(this.render(object));
        }
    }

    public static class TitledText
    implements Comparable<TitledText> {
        private String title;
        private String description;

        public TitledText(String title, String description) {
            this.title = title;
            this.description = description;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public int compareTo(TitledText o) {
            return this.title.compareTo(o.title);
        }
    }
}

