/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.properties.editor.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.properties.editor.model.PropertyEditorCategory;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;

public class PropertyEditorEvent {
    private List<PropertyEditorCategory> properties = new ArrayList<PropertyEditorCategory>();

    public PropertyEditorEvent(String idEvent, List<PropertyEditorCategory> properties) {
        PortablePreconditions.checkNotNull((String)"idEvent", (Object)idEvent);
        PortablePreconditions.checkNotNull((String)"properties", properties);
        for (PropertyEditorCategory property : properties) {
            property.setIdEvent(idEvent);
        }
        this.properties = properties;
    }

    public PropertyEditorEvent(String idEvent, PropertyEditorCategory property) {
        PortablePreconditions.checkNotNull((String)"idEvent", (Object)idEvent);
        PortablePreconditions.checkNotNull((String)"property", (Object)property);
        property.setIdEvent(idEvent);
        this.properties.add(property);
    }

    public List<PropertyEditorCategory> getSortedProperties() {
        PropertyEditorEvent.sortCategoriesAndFieldsByPriority(this.properties);
        return this.properties;
    }

    private static void sortCategoriesAndFieldsByPriority(List<PropertyEditorCategory> properties) {
        PropertyEditorEvent.sortCategoriesByPriority(properties);
        PropertyEditorEvent.sortEditorFieldInfoByPriority(properties);
    }

    private static void sortCategoriesByPriority(List<PropertyEditorCategory> properties) {
        Collections.sort(properties, new Comparator<PropertyEditorCategory>(){

            @Override
            public int compare(PropertyEditorCategory o1, PropertyEditorCategory o2) {
                if (o1.getPriority() < o2.getPriority()) {
                    return -1;
                }
                if (o1.getPriority() > o2.getPriority()) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private static void sortEditorFieldInfoByPriority(List<PropertyEditorCategory> properties) {
        for (PropertyEditorCategory category : properties) {
            Collections.sort(category.getFields(), new Comparator<PropertyEditorFieldInfo>(){

                @Override
                public int compare(PropertyEditorFieldInfo o1, PropertyEditorFieldInfo o2) {
                    if (o1.getPriority() < o2.getPriority()) {
                        return -1;
                    }
                    if (o1.getPriority() > o2.getPriority()) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
    }
}

