/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.properties.editor.client;

import com.github.gwtbootstrap.client.ui.Accordion;
import com.github.gwtbootstrap.client.ui.AccordionGroup;
import com.github.gwtbootstrap.client.ui.event.HiddenEvent;
import com.github.gwtbootstrap.client.ui.event.HiddenHandler;
import com.github.gwtbootstrap.client.ui.event.ShowEvent;
import com.github.gwtbootstrap.client.ui.event.ShowHandler;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.ioc.client.container.IOCBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.ext.properties.editor.client.PropertyEditorItemWidget;
import org.uberfire.ext.properties.editor.client.PropertyEditorWidget;
import org.uberfire.ext.properties.editor.client.fields.AbstractField;
import org.uberfire.ext.properties.editor.client.fields.PropertyEditorFieldType;
import org.uberfire.ext.properties.editor.client.widgets.AbstractPropertyEditorWidget;
import org.uberfire.ext.properties.editor.client.widgets.PropertyEditorErrorWidget;
import org.uberfire.ext.properties.editor.client.widgets.PropertyEditorItemHelp;
import org.uberfire.ext.properties.editor.client.widgets.PropertyEditorItemLabel;
import org.uberfire.ext.properties.editor.client.widgets.PropertyEditorItemRemovalButton;
import org.uberfire.ext.properties.editor.client.widgets.PropertyEditorItemsWidget;
import org.uberfire.ext.properties.editor.model.CustomPropertyEditorFieldInfo;
import org.uberfire.ext.properties.editor.model.PropertyEditorCategory;
import org.uberfire.ext.properties.editor.model.PropertyEditorEvent;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;

public class PropertyEditorHelper {
    public static void extractEditorFrom(PropertyEditorWidget propertyEditorWidget, Accordion propertyMenu, PropertyEditorEvent event, String propertyNameFilter) {
        propertyMenu.clear();
        for (PropertyEditorCategory category : event.getSortedProperties()) {
            PropertyEditorHelper.createCategory(propertyEditorWidget, propertyMenu, category, propertyNameFilter);
        }
    }

    public static void extractEditorFrom(PropertyEditorWidget propertyEditorWidget, Accordion propertyMenu, PropertyEditorEvent event) {
        PropertyEditorHelper.extractEditorFrom(propertyEditorWidget, propertyMenu, event, "");
    }

    static void createCategory(PropertyEditorWidget propertyEditorWidget, Accordion propertyMenu, PropertyEditorCategory category, String propertyNameFilter) {
        AccordionGroup categoryAccordion = PropertyEditorHelper.createAccordionGroup(propertyEditorWidget, category);
        boolean categoryHasActiveChilds = false;
        for (PropertyEditorFieldInfo field : category.getFields()) {
            if (!PropertyEditorHelper.isAMatchOfFilter(propertyNameFilter, field)) continue;
            categoryHasActiveChilds = true;
            categoryAccordion.add((Widget)PropertyEditorHelper.createItemsWidget(field, category, categoryAccordion));
        }
        if (categoryHasActiveChilds) {
            propertyMenu.add((Widget)categoryAccordion);
        }
    }

    static AccordionGroup createAccordionGroup(final PropertyEditorWidget propertyEditorWidget, final PropertyEditorCategory category) {
        AccordionGroup categoryAccordion = (AccordionGroup)GWT.create(AccordionGroup.class);
        categoryAccordion.setHeading(category.getName());
        categoryAccordion.addShowHandler(new ShowHandler(){

            public void onShow(ShowEvent showEvent) {
                propertyEditorWidget.setLastOpenAccordionGroupTitle(category.getName());
            }
        });
        categoryAccordion.addHiddenHandler(new HiddenHandler(){

            public void onHidden(HiddenEvent hiddenEvent) {
                hiddenEvent.stopPropagation();
            }
        });
        if (propertyEditorWidget.getLastOpenAccordionGroupTitle().equals(category.getName())) {
            categoryAccordion.setDefaultOpen(true);
        }
        return categoryAccordion;
    }

    static PropertyEditorItemsWidget createItemsWidget(PropertyEditorFieldInfo field, PropertyEditorCategory category, AccordionGroup categoryAccordion) {
        PropertyEditorItemsWidget items = (PropertyEditorItemsWidget)((Object)GWT.create(PropertyEditorItemsWidget.class));
        items.add((Widget)PropertyEditorHelper.createLabel(field));
        items.add((Widget)PropertyEditorHelper.createField(field, items));
        if (field.hasHelpInfo()) {
            items.add((Widget)PropertyEditorHelper.createHelp(field));
        }
        if (field.isRemovalSupported()) {
            items.add((Widget)PropertyEditorHelper.createRemovalButton(field, category, items, categoryAccordion));
        }
        return items;
    }

    static PropertyEditorItemLabel createLabel(PropertyEditorFieldInfo field) {
        PropertyEditorItemLabel item = (PropertyEditorItemLabel)((Object)GWT.create(PropertyEditorItemLabel.class));
        item.setText(field.getLabel());
        return item;
    }

    static PropertyEditorItemHelp createHelp(PropertyEditorFieldInfo field) {
        PropertyEditorItemHelp itemHelp = (PropertyEditorItemHelp)((Object)GWT.create(PropertyEditorItemHelp.class));
        itemHelp.setHeading(field.getHelpHeading());
        itemHelp.setText(field.getHelpText());
        return itemHelp;
    }

    static PropertyEditorItemWidget createField(PropertyEditorFieldInfo field, PropertyEditorItemsWidget parent) {
        Widget widget;
        PropertyEditorItemWidget itemWidget = (PropertyEditorItemWidget)((Object)GWT.create(PropertyEditorItemWidget.class));
        PropertyEditorErrorWidget errorWidget = (PropertyEditorErrorWidget)((Object)GWT.create(PropertyEditorErrorWidget.class));
        PropertyEditorFieldType editorFieldType = PropertyEditorFieldType.getFieldTypeFrom(field);
        if (editorFieldType == PropertyEditorFieldType.CUSTOM) {
            Class widgetClass = ((CustomPropertyEditorFieldInfo)field).getCustomEditorClass();
            widget = PropertyEditorHelper.getWidget(field, widgetClass);
        } else {
            widget = editorFieldType.widget(field);
        }
        PropertyEditorHelper.createErrorHandlingInfraStructure(parent, itemWidget, errorWidget, widget);
        itemWidget.add(widget);
        itemWidget.add((Widget)errorWidget);
        return itemWidget;
    }

    private static Widget getWidget(PropertyEditorFieldInfo property, Class fieldType) {
        SyncBeanManager beanManager = IOC.getBeanManager();
        IOCBeanDef iocBeanDef = beanManager.lookupBean(fieldType, new Annotation[0]);
        AbstractField field = (AbstractField)iocBeanDef.getInstance();
        return field.widget(property);
    }

    static void createErrorHandlingInfraStructure(PropertyEditorItemsWidget parent, PropertyEditorItemWidget itemWidget, PropertyEditorErrorWidget errorWidget, Widget widget) {
        AbstractPropertyEditorWidget abstractPropertyEditorWidget = (AbstractPropertyEditorWidget)widget;
        abstractPropertyEditorWidget.setErrorWidget(errorWidget);
        abstractPropertyEditorWidget.setParent(parent);
        itemWidget.add(widget);
    }

    static PropertyEditorItemRemovalButton createRemovalButton(final PropertyEditorFieldInfo field, final PropertyEditorCategory category, final PropertyEditorItemsWidget items, final AccordionGroup categoryAccordion) {
        PropertyEditorItemRemovalButton button = new PropertyEditorItemRemovalButton();
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                category.getFields().remove(field);
                categoryAccordion.remove((Widget)items);
            }
        });
        return button;
    }

    public static boolean validade(PropertyEditorEvent event) {
        if (event == null) {
            throw new NullEventException();
        }
        if (event.getSortedProperties().isEmpty()) {
            throw new NoPropertiesException();
        }
        return event != null && !event.getSortedProperties().isEmpty();
    }

    static boolean isAMatchOfFilter(String propertyNameFilter, PropertyEditorFieldInfo field) {
        if (propertyNameFilter.isEmpty()) {
            return true;
        }
        return field.getLabel().toUpperCase().contains(propertyNameFilter.toUpperCase());
    }

    public static class NoPropertiesException
    extends RuntimeException {
    }

    public static class NullEventException
    extends RuntimeException {
    }
}

