/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.properties.editor.client.fields;

import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.ext.properties.editor.client.fields.AbstractField;
import org.uberfire.ext.properties.editor.client.fields.BooleanField;
import org.uberfire.ext.properties.editor.client.fields.ColorField;
import org.uberfire.ext.properties.editor.client.fields.ComboField;
import org.uberfire.ext.properties.editor.client.fields.SecretTextField;
import org.uberfire.ext.properties.editor.client.fields.TextField;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;

public enum PropertyEditorFieldType {
    TEXT{

        @Override
        public Widget widget(PropertyEditorFieldInfo property) {
            return PropertyEditorFieldType.getWidget(property, TextField.class);
        }
    }
    ,
    BOOLEAN{

        @Override
        public Widget widget(PropertyEditorFieldInfo property) {
            return PropertyEditorFieldType.getWidget(property, BooleanField.class);
        }
    }
    ,
    NATURAL_NUMBER{

        @Override
        public Widget widget(PropertyEditorFieldInfo property) {
            return TEXT.widget(property);
        }
    }
    ,
    COMBO{

        @Override
        public Widget widget(PropertyEditorFieldInfo property) {
            return PropertyEditorFieldType.getWidget(property, ComboField.class);
        }
    }
    ,
    SECRET_TEXT{

        @Override
        public Widget widget(PropertyEditorFieldInfo property) {
            return PropertyEditorFieldType.getWidget(property, SecretTextField.class);
        }
    }
    ,
    COLOR{

        @Override
        public Widget widget(PropertyEditorFieldInfo property) {
            return PropertyEditorFieldType.getWidget(property, ColorField.class);
        }
    }
    ,
    CUSTOM{

        @Override
        public Widget widget(PropertyEditorFieldInfo property) {
            return null;
        }
    };


    private static Widget getWidget(PropertyEditorFieldInfo property, Class fieldType) {
        SyncBeanManager beanManager = IOC.getBeanManager();
        SyncBeanDef iocBeanDef = beanManager.lookupBean(fieldType, new Annotation[0]);
        AbstractField field = (AbstractField)iocBeanDef.getInstance();
        return field.widget(property);
    }

    public abstract Widget widget(PropertyEditorFieldInfo var1);

    public static PropertyEditorFieldType getFieldTypeFrom(PropertyEditorFieldInfo fieldInfo) {
        return PropertyEditorFieldType.valueOf(fieldInfo.getType().name());
    }
}

