/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.properties.editor.client.fields;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.uberfire.ext.properties.editor.client.fields.AbstractField;
import org.uberfire.ext.properties.editor.client.widgets.PropertyEditorComboBox;
import org.uberfire.ext.properties.editor.model.PropertyEditorChangeEvent;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;

@Dependent
public class ComboField
extends AbstractField {
    @Inject
    Event<PropertyEditorChangeEvent> propertyEditorChangeEventEvent;

    @Override
    public Widget widget(PropertyEditorFieldInfo property) {
        PropertyEditorComboBox listBox = (PropertyEditorComboBox)((Object)GWT.create(PropertyEditorComboBox.class));
        int index = 0;
        int selected = -1;
        for (String value : property.getComboValues()) {
            listBox.addItem(value);
            selected = this.searchSelectItem(property, index, selected, value);
            ++index;
        }
        this.ifSelectedSelectItem(listBox, index, selected);
        this.addChangeHandler(property, listBox);
        return listBox;
    }

    private void ifSelectedSelectItem(PropertyEditorComboBox listBox, int index, int selected) {
        if (this.selectAnyItem(index)) {
            listBox.setSelectedIndex(selected);
        }
    }

    private void addChangeHandler(final PropertyEditorFieldInfo property, final PropertyEditorComboBox listBox) {
        listBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                int selectedIndex = listBox.getSelectedIndex();
                if (ComboField.this.validate(property, listBox.getItemText(selectedIndex))) {
                    listBox.clearOldValidationErrors();
                    property.setCurrentStringValue(listBox.getItemText(selectedIndex));
                    ComboField.this.propertyEditorChangeEventEvent.fire((Object)new PropertyEditorChangeEvent(property, listBox.getItemText(selectedIndex)));
                } else {
                    listBox.setValidationError(ComboField.this.getValidatorErrorMessage(property, listBox.getItemText(selectedIndex)));
                    listBox.setSelectItemByText(property.getCurrentStringValue());
                }
            }
        });
    }

    private int searchSelectItem(PropertyEditorFieldInfo property, int index, int selected, String value) {
        if (value.equalsIgnoreCase(property.getCurrentStringValue())) {
            selected = index;
        }
        return selected;
    }

    private boolean selectAnyItem(int index) {
        return index >= 0;
    }
}

