/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.properties.editor.client.fields;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.uberfire.ext.properties.editor.client.fields.AbstractField;
import org.uberfire.ext.properties.editor.client.widgets.PropertyEditorColorPicker;
import org.uberfire.ext.properties.editor.model.PropertyEditorChangeEvent;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;

@Dependent
public class ColorField
extends AbstractField {
    @Inject
    Event<PropertyEditorChangeEvent> propertyEditorChangeEvent;

    @Override
    public Widget widget(PropertyEditorFieldInfo property) {
        PropertyEditorColorPicker colorPicker = (PropertyEditorColorPicker)((Object)GWT.create(PropertyEditorColorPicker.class));
        String colorCode = property.getCurrentStringValue();
        colorPicker.setValue(colorCode.startsWith("#") ? colorCode.substring(1) : colorCode);
        colorPicker.addChangeHandler((ValueChangeHandler<String>)((ValueChangeHandler)event -> {
            String color = colorPicker.getValue();
            if (color.isEmpty() || this.validate(property, color)) {
                colorPicker.clearOldValidationErrors();
                property.setCurrentStringValue(color);
                this.propertyEditorChangeEvent.fire((Object)new PropertyEditorChangeEvent(property, "#" + color));
            } else {
                colorPicker.setValidationError(this.getValidatorErrorMessage(property, color));
                colorPicker.setValue(property.getCurrentStringValue());
            }
        }));
        return colorPicker;
    }
}

