/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.user;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.validation.ConstraintViolation;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.resources.i18n.UsersManagementWidgetsConstants;
import org.uberfire.ext.security.management.client.widgets.management.editor.AssignedEntitiesExplorer;
import org.uberfire.ext.security.management.client.widgets.management.list.EntitiesList;
import org.uberfire.ext.security.management.client.widgets.management.list.EntitiesPagedList;
import org.uberfire.ext.security.management.client.widgets.popup.ConfirmBox;
import org.uberfire.mvp.Command;

public abstract class UserAssignedEntitiesExplorer<T>
implements IsWidget {
    protected static final int PAGE_SIZE = 5;
    ClientUserSystemManager userSystemManager;
    ConfirmBox confirmBox;
    EntitiesPagedList<T> entitiesList;
    public AssignedEntitiesExplorer view;
    protected Set<T> entities = new LinkedHashSet<T>();
    protected boolean isEditMode;

    @Inject
    public UserAssignedEntitiesExplorer(ClientUserSystemManager userSystemManager, ConfirmBox confirmBox, EntitiesPagedList<T> entitiesList, AssignedEntitiesExplorer view) {
        this.userSystemManager = userSystemManager;
        this.confirmBox = confirmBox;
        this.entitiesList = entitiesList;
        this.view = view;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    protected abstract String getEmptyText();

    protected abstract String getEntityType();

    protected abstract String getTitle();

    protected abstract String getEntityId(T var1);

    protected abstract String getEntityName(T var1);

    protected abstract String getEnsureRemoveText();

    protected abstract boolean canAssignEntities();

    protected abstract void doShow();

    protected abstract void removeEntity(String var1);

    @PostConstruct
    public void init() {
        this.entitiesList.setPageSize(5);
        this.entitiesList.setEmptyEntitiesText(this.getEmptyText());
        this.view.configure(this.getTitle(), this.entitiesList.view);
    }

    public void show(User user) {
        this.clear();
        this.isEditMode = false;
        this.open(user);
    }

    public void edit(User user) {
        this.clear();
        this.isEditMode = true;
        this.open(user);
    }

    public void flush() {
        assert (this.isEditMode);
    }

    public Set<T> getValue() {
        return this.entities;
    }

    public void setViolations(Set<ConstraintViolation<User>> constraintViolations) {
    }

    public void clear() {
        this.view.clear();
        this.entitiesList.clear();
        this.isEditMode = false;
        this.entities.clear();
    }

    protected EntitiesList.Callback<T> getCallback() {
        return new EntitiesList.Callback<T>(){

            @Override
            public String getEntityType() {
                return UserAssignedEntitiesExplorer.this.getEntityType();
            }

            @Override
            public boolean canRead() {
                return true;
            }

            @Override
            public boolean canRemove() {
                return UserAssignedEntitiesExplorer.this.canAssignEntities();
            }

            @Override
            public boolean canSelect() {
                return false;
            }

            @Override
            public boolean isSelected(String identifier) {
                return false;
            }

            @Override
            public String getIdentifier(T entity) {
                return UserAssignedEntitiesExplorer.this.getEntityId(entity);
            }

            @Override
            public String getTitle(T entity) {
                return UserAssignedEntitiesExplorer.this.getEntityName(entity);
            }

            @Override
            public void onReadEntity(String identifier) {
            }

            @Override
            public void onRemoveEntity(final String identifier) {
                if (identifier != null) {
                    UserAssignedEntitiesExplorer.this.confirmBox.show(UsersManagementWidgetsConstants.INSTANCE.confirmAction(), UserAssignedEntitiesExplorer.this.getEnsureRemoveText(), new Command(){

                        public void execute() {
                            UserAssignedEntitiesExplorer.this.removeEntity(identifier);
                        }
                    });
                }
            }

            @Override
            public void onSelectEntity(String identifier, boolean isSelected) {
            }

            @Override
            public void onChangePage(int currentPage, int goToPage) {
            }
        };
    }

    protected void open(User user) {
        assert (user != null);
        this.doShow();
    }
}

