/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.acl.node;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.BasePermissionNodeEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionNodeEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionSwitch;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionSwitchToogle;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionWidgetFactory;
import org.uberfire.ext.security.management.client.widgets.management.events.PermissionChangedEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.PermissionNodeAddedEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.PermissionNodeRemovedEvent;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchDropDown;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchService;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.client.authz.tree.HasResources;
import org.uberfire.security.client.authz.tree.LoadOptions;
import org.uberfire.security.client.authz.tree.PermissionNode;
import org.uberfire.security.client.authz.tree.PermissionTreeProvider;
import org.uberfire.security.client.authz.tree.impl.DefaultLoadOptions;
import org.uberfire.security.client.authz.tree.impl.PermissionResourceNode;

@Dependent
public class MultiplePermissionNodeEditor
extends BasePermissionNodeEditor {
    View view;
    PermissionWidgetFactory widgetFactory;
    LiveSearchDropDown liveSearchDropDown;
    Event<PermissionChangedEvent> permissionChangedEvent;
    Event<PermissionNodeAddedEvent> permissionNodeAddedEvent;
    Event<PermissionNodeRemovedEvent> permissionNodeRemovedEvent;
    Map<String, PermissionNode> childSelectorNodeMap = new TreeMap<String, PermissionNode>();
    boolean expanded = false;
    LiveSearchService childrenSearchService = (pattern, maxResults, callback) -> {
        PermissionTreeProvider provider = this.permissionNode.getPermissionTreeProvider();
        DefaultLoadOptions loadOptions = new DefaultLoadOptions();
        loadOptions.setNodeNamePattern(pattern);
        loadOptions.setMaxNodes(maxResults);
        provider.loadChildren(this.permissionNode, (LoadOptions)loadOptions, children -> {
            this.childSelectorNodeMap.clear();
            for (PermissionNode childNode : children) {
                String childName = childNode.getNodeName();
                if (this.childAlreadyAdded(childName)) continue;
                this.childSelectorNodeMap.put(childName, childNode);
            }
            ArrayList<String> result = new ArrayList<String>(this.childSelectorNodeMap.keySet());
            callback.afterSearch(result);
        });
    };

    @Inject
    public MultiplePermissionNodeEditor(View view, LiveSearchDropDown liveSearchDropDown, PermissionWidgetFactory widgetFactory, Event<PermissionChangedEvent> permissionChangedEvent, Event<PermissionNodeAddedEvent> permissionNodeAddedEvent, Event<PermissionNodeRemovedEvent> permissionNodeRemovedEvent) {
        this.view = view;
        this.liveSearchDropDown = liveSearchDropDown;
        this.widgetFactory = widgetFactory;
        this.permissionChangedEvent = permissionChangedEvent;
        this.permissionNodeAddedEvent = permissionNodeAddedEvent;
        this.permissionNodeRemovedEvent = permissionNodeRemovedEvent;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public boolean hasResources() {
        return this.permissionNode instanceof HasResources;
    }

    @Override
    public void edit(PermissionNode node) {
        this.permissionNode = node;
        this.permissionSwitchMap.clear();
        String name = node.getNodeName();
        String fullName = node.getNodeFullName();
        this.view.setNodeName(name);
        this.view.setNodePanelWidth(this.getNodePanelWidth());
        this.view.setClearChildrenEnabled(false);
        if (fullName != null && !fullName.equals(name)) {
            this.view.setNodeFullName(fullName);
        }
        this.view.setAddChildEnabled(false);
        if (this.hasResources()) {
            String resourceName = ((PermissionResourceNode)this.permissionNode).getResourceName();
            this.liveSearchDropDown.setSelectorHint(this.view.getChildSelectorHint(resourceName));
            this.liveSearchDropDown.setSearchHint(this.view.getChildSearchHint(resourceName));
            this.liveSearchDropDown.setNotFoundMessage(this.view.getChildrenNotFoundMsg(resourceName));
            this.liveSearchDropDown.setMaxItems(50);
            this.liveSearchDropDown.setWidth(220);
            this.liveSearchDropDown.setSearchService(this.childrenSearchService);
            this.liveSearchDropDown.setOnChange(() -> this.onChildSelected(this.liveSearchDropDown.getSelectedItem()));
            this.view.setAddChildEnabled(true);
            this.view.setResourceName(resourceName);
            this.view.setChildSelector((IsWidget)this.liveSearchDropDown);
        }
        for (Permission permission : this.permissionNode.getPermissionList()) {
            String grantName = this.permissionNode.getPermissionGrantName(permission);
            String denyName = this.permissionNode.getPermissionDenyName(permission);
            boolean granted = AuthorizationResult.ACCESS_GRANTED.equals((Object)permission.getResult());
            PermissionSwitch permissionSwitch = this.widgetFactory.createSwitch();
            permissionSwitch.init(grantName, denyName, granted, 0);
            permissionSwitch.setOnChange(() -> {
                permission.setResult(permissionSwitch.isOn() ? AuthorizationResult.ACCESS_GRANTED : AuthorizationResult.ACCESS_DENIED);
                super.onPermissionChanged(permission, permissionSwitch.isOn());
                this.permissionChangedEvent.fire((Object)new PermissionChangedEvent(this.getACLEditor(), permission, permissionSwitch.isOn()));
            });
            super.registerPermissionSwitch(permission, permissionSwitch);
        }
        super.processAllPermissionDependencies();
        for (PermissionSwitchToogle switchToogle : this.permissionSwitchMap.values()) {
            this.view.addPermission(switchToogle);
        }
        this.loadChildren();
    }

    @Override
    protected void notifyPermissionChange(Permission permission, boolean on) {
        super.notifyPermissionChange(permission, on);
        PermissionSwitchToogle permissionSwitch = (PermissionSwitchToogle)this.permissionSwitchMap.get(permission);
        int n = this.getExceptionNumber(permission);
        permissionSwitch.setNumberOfExceptions(n);
    }

    public void expand() {
        this.expanded = true;
        List<PermissionNodeEditor> childEditors = this.getChildEditors();
        this.view.setExpanded(true);
        this.view.clearChildren();
        for (int i = 0; i < childEditors.size(); ++i) {
            PermissionNodeEditor nodeEditor = childEditors.get(i);
            this.view.addChildEditor(nodeEditor, this.hasResources());
            if (i >= childEditors.size() - 1) continue;
            this.view.addChildSeparator();
        }
        if (!childEditors.isEmpty()) {
            this.view.setClearChildrenEnabled(this.hasResources());
        }
    }

    public void collapse() {
        this.permissionNode.collapse();
        this.expanded = false;
        this.view.setExpanded(false);
        this.view.clearChildren();
    }

    protected void loadChildren() {
        this.permissionNode.expand(children -> {
            for (PermissionNode child : children) {
                this.registerChild(child);
            }
            this.updateExceptionCounters();
        });
    }

    protected PermissionNodeEditor registerChild(PermissionNode child) {
        PermissionNodeEditor nodeEditor = this.widgetFactory.createEditor(child);
        nodeEditor.setACLEditor(this.getACLEditor());
        nodeEditor.setTreeLevel(this.getTreeLevel() + 1);
        nodeEditor.setParentEditor(this);
        nodeEditor.edit(child);
        super.addChildEditor(nodeEditor);
        return nodeEditor;
    }

    @Override
    public void onChildPermissionChanged(PermissionNodeEditor childEditor, Permission permission, boolean on) {
        this.updateExceptionCounters();
    }

    @Override
    protected void onNodePanelWidthChanged() {
        int width = this.getNodePanelWidth();
        this.view.setNodePanelWidth(width);
    }

    private void updateExceptionCounters() {
        for (Permission p : this.permissionSwitchMap.keySet()) {
            PermissionSwitchToogle pswitch = (PermissionSwitchToogle)this.permissionSwitchMap.get(p);
            int n = this.getExceptionNumber(p);
            pswitch.setNumberOfExceptions(n);
        }
    }

    public void onNodeClick() {
        if (this.expanded) {
            this.collapse();
        } else {
            this.expand();
        }
    }

    public void onAddChildStart() {
        this.view.showChildSelector();
    }

    public void onAddChildCancel() {
        this.view.hideChildSelector();
    }

    public void onClearChildren() {
        for (PermissionNodeEditor child : new ArrayList<PermissionNodeEditor>(this.getChildEditors())) {
            this.removeChild(child);
        }
        this.view.setClearChildrenEnabled(false);
        this.updateExceptionCounters();
    }

    public void onRemoveChild(PermissionNodeEditor child) {
        this.removeChild(child);
        this.updateExceptionCounters();
        this.view.setClearChildrenEnabled(this.hasResources() && this.hasChildEditors());
    }

    protected void removeChild(PermissionNodeEditor child) {
        super.removeChildEditor(child);
        this.liveSearchDropDown.clear();
        this.view.hideChildSelector();
        this.view.clearChildren();
        List<PermissionNodeEditor> childEditors = this.getChildEditors();
        for (int i = 0; i < childEditors.size(); ++i) {
            PermissionNodeEditor nodeEditor = childEditors.get(i);
            this.view.addChildEditor(nodeEditor, this.hasResources());
            if (i >= childEditors.size() - 1) continue;
            this.view.addChildSeparator();
        }
        this.permissionNodeRemovedEvent.fire((Object)new PermissionNodeRemovedEvent(this.getACLEditor(), this.permissionNode, child.getPermissionNode()));
    }

    public void onChildSelected(String childName) {
        PermissionNode childNode = this.childSelectorNodeMap.remove(childName);
        this.overwritePermissions(childNode);
        PermissionNodeEditor childEditor = this.registerChild(childNode);
        if (this.view.hasChildren()) {
            this.view.addChildSeparator();
        }
        this.view.addChildEditor(childEditor, this.hasResources());
        this.view.setClearChildrenEnabled(true);
        this.view.hideChildSelector();
        this.liveSearchDropDown.clear();
        this.updateExceptionCounters();
        this.permissionNodeAddedEvent.fire((Object)new PermissionNodeAddedEvent(this.getACLEditor(), this.permissionNode, childNode));
    }

    protected void overwritePermissions(PermissionNode child) {
        for (Permission p1 : this.permissionNode.getPermissionList()) {
            for (Permission p2 : child.getPermissionList()) {
                if (!p1.impliesName(p2)) continue;
                p2.setResult(p1.getResult().invert());
            }
        }
    }

    protected boolean childAlreadyAdded(String nodeName) {
        for (PermissionNodeEditor childEditor : this.getChildEditors()) {
            String existingName = childEditor.getPermissionNode().getNodeName();
            if (!existingName.equals(nodeName)) continue;
            return true;
        }
        return false;
    }

    public static interface View
    extends UberView<MultiplePermissionNodeEditor> {
        public void setNodeName(String var1);

        public void setNodePanelWidth(int var1);

        public void setNodeFullName(String var1);

        public void setResourceName(String var1);

        public void addPermission(PermissionSwitchToogle var1);

        public void addChildEditor(PermissionNodeEditor var1, boolean var2);

        public void addChildSeparator();

        public boolean hasChildren();

        public void clearChildren();

        public String getChildSelectorHint(String var1);

        public String getChildSearchHint(String var1);

        public String getChildrenNotFoundMsg(String var1);

        public void setChildSelector(IsWidget var1);

        public void showChildSelector();

        public void hideChildSelector();

        public void setAddChildEnabled(boolean var1);

        public void setClearChildrenEnabled(boolean var1);

        public void setExpanded(boolean var1);
    }
}

