/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.acl.node;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.ext.security.management.client.resources.i18n.SecurityManagementConstants;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.MultiplePermissionNodeViewer;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.node.PermissionNodeViewer;

@Dependent
@Templated
public class MultiplePermissionNodeViewerView
extends Composite
implements MultiplePermissionNodeViewer.View {
    private MultiplePermissionNodeViewer presenter;
    @Inject
    @DataField
    Anchor nodeAnchor;
    @Inject
    @DataField
    Div nodeAnchorPanel;
    @Inject
    @DataField
    FlowPanel nodePermissions;
    @Inject
    @DataField
    Div collapsePanel;
    @Inject
    @DataField
    FlowPanel nodeChildren;

    public void init(MultiplePermissionNodeViewer presenter) {
        this.presenter = presenter;
        String collapseId = Document.get().createUniqueId();
        this.collapsePanel.setId(collapseId);
        this.nodeAnchor.setDataToggle(Toggle.COLLAPSE);
        this.nodeAnchor.setDataTarget("#" + collapseId);
    }

    @Override
    public void setNodeName(String name) {
        this.nodeAnchor.setText(name);
    }

    @Override
    public void setNodeFullName(String name) {
        this.nodeAnchor.setTitle(name);
    }

    @Override
    public void setPermissionsVisible(boolean enabled) {
        this.nodePermissions.setVisible(enabled);
    }

    @Override
    public void addChildViewer(PermissionNodeViewer viewer) {
        this.nodeChildren.add((IsWidget)viewer);
    }

    private Label createLabel(String text, String color) {
        Label l = new Label(text);
        l.getElement().getStyle().setMarginLeft(3.0, Style.Unit.PX);
        if (color != null) {
            l.getElement().getStyle().setColor(color);
        }
        return l;
    }

    private void addPermissionMessage(String preffix, String permission, String inffix, String resource, String suffix, String color) {
        Label l;
        HorizontalPanel panel = new HorizontalPanel();
        if (preffix != null) {
            l = this.createLabel(preffix, null);
            panel.add((Widget)l);
        }
        if (permission != null) {
            l = this.createLabel(permission, color);
            panel.add((Widget)l);
        }
        if (inffix != null) {
            l = this.createLabel(inffix, null);
            panel.add((Widget)l);
        }
        if (resource != null) {
            l = this.createLabel(resource, null);
            panel.add((Widget)l);
        }
        if (suffix != null) {
            l = this.createLabel(suffix, null);
            panel.add((Widget)l);
        }
        this.nodePermissions.add((Widget)panel);
    }

    @Override
    public void addAllItemsGrantedPermission(String permission, String resource) {
        String can = SecurityManagementConstants.INSTANCE.can();
        this.addPermissionMessage(can, permission, null, resource, null, "#00618a");
    }

    @Override
    public void addAllItemsDeniedPermission(String permission, String resource) {
        String cant = SecurityManagementConstants.INSTANCE.cant();
        this.addPermissionMessage(cant, permission, null, resource, null, "#a30000");
    }

    @Override
    public void addItemsGrantedPermission(String permission, String resource) {
        String can = SecurityManagementConstants.INSTANCE.can();
        String all = SecurityManagementConstants.INSTANCE.all();
        String but = SecurityManagementConstants.INSTANCE.but();
        this.addPermissionMessage(can, permission, all, resource, but + ":", "#00618a");
    }

    @Override
    public void addItemsDeniedPermission(String permission, String resource) {
        String canOnly = SecurityManagementConstants.INSTANCE.canOnly();
        String following = SecurityManagementConstants.INSTANCE.following();
        this.addPermissionMessage(canOnly, permission, following, resource + ":", null, "#a30000");
    }

    @Override
    public void addItemException(String item) {
        HorizontalPanel panel = new HorizontalPanel();
        Label l = this.createLabel("- " + item, null);
        panel.add((Widget)l);
        panel.getElement().getStyle().setMarginLeft(15.0, Style.Unit.PX);
        this.nodePermissions.add((Widget)panel);
    }
}

