/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.explorer;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.constants.HeadingSize;
import org.jboss.errai.security.shared.api.Group;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.security.management.client.resources.i18n.UsersManagementWidgetsConstants;
import org.uberfire.ext.security.management.client.widgets.management.events.RemoveUserGroupEvent;
import org.uberfire.ext.security.management.client.widgets.management.list.EntitiesList;
import org.uberfire.ext.security.management.client.widgets.management.list.GroupsList;
import org.uberfire.ext.security.management.client.widgets.popup.ConfirmBox;

@Dependent
public class UserGroupsExplorer
implements IsWidget {
    protected GroupsList groupList;
    protected View view;
    ConfirmBox confirmBox;
    private Event<RemoveUserGroupEvent> removeUserGroupEventEvent;
    private static final int PAGE_SIZE = 5;
    boolean canRemove;

    @Inject
    public UserGroupsExplorer(GroupsList groupList, View view, ConfirmBox confirmBox, Event<RemoveUserGroupEvent> removeUserGroupEventEvent) {
        this.groupList = groupList;
        this.view = view;
        this.confirmBox = confirmBox;
        this.removeUserGroupEventEvent = removeUserGroupEventEvent;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    @PostConstruct
    public void init() {
        this.groupList.setPageSize(5);
        this.groupList.setEmptyEntitiesText(UsersManagementWidgetsConstants.INSTANCE.userHasNoGroups());
        this.groupList.setEntityTitleSize(HeadingSize.H5);
        this.view.configure(this.groupList.view);
    }

    public void show(final Set<Group> groups, boolean canRemove) {
        this.clear();
        this.canRemove = canRemove;
        this.groupList.show(groups, new EntitiesList.Callback<Group>(){

            @Override
            public String getEntityType() {
                return UsersManagementWidgetsConstants.INSTANCE.groupsAssigned();
            }

            @Override
            public boolean canRead() {
                return false;
            }

            @Override
            public boolean canRemove() {
                return UserGroupsExplorer.this.canRemove;
            }

            @Override
            public boolean canSelect() {
                return false;
            }

            @Override
            public boolean isSelected(String id) {
                return groups != null && groups.contains(id);
            }

            @Override
            public String getIdentifier(Group entity) {
                return entity.getName();
            }

            @Override
            public String getTitle(Group entity) {
                return entity.getName();
            }

            @Override
            public void onReadEntity(String identifier) {
            }

            @Override
            public void onRemoveEntity(String identifier) {
                if (identifier != null) {
                    UserGroupsExplorer.this.confirmBox.show(UsersManagementWidgetsConstants.INSTANCE.confirmAction(), UsersManagementWidgetsConstants.INSTANCE.ensureRemoveGroupFromUser(), () -> UserGroupsExplorer.this.removeUserGroupEventEvent.fire((Object)new RemoveUserGroupEvent(UserGroupsExplorer.this, identifier)), () -> {});
                }
            }

            @Override
            public void onSelectEntity(String identifier, boolean isSelected) {
            }

            @Override
            public void onChangePage(int currentPage, int goToPage) {
            }
        });
    }

    public void clear() {
        this.view.clear();
        this.canRemove = false;
    }

    public static interface View
    extends UberView<UserGroupsExplorer> {
        public View configure(EntitiesList.View var1);

        public View clear();
    }
}

