/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.user;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.EditTextCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.ProvidesKey;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.validation.ConstraintViolation;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.gwt.ButtonCell;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.api.UserManager;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.resources.i18n.UsersManagementWidgetsConstants;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.NewUserAttributeEditor;
import org.uberfire.ext.security.management.client.widgets.management.events.CreateUserAttributeEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.DeleteUserAttributeEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnErrorEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.UpdateUserAttributeEvent;
import org.uberfire.ext.security.management.client.widgets.popup.ConfirmBox;

@Dependent
public class UserAttributesEditor
implements IsWidget,
org.uberfire.ext.security.management.client.editor.user.UserAttributesEditor {
    ClientUserSystemManager userSystemManager;
    ConfirmBox confirmBox;
    Event<CreateUserAttributeEvent> createUserAttributeEventEvent;
    Event<UpdateUserAttributeEvent> updateUserAttributeEventEvent;
    Event<DeleteUserAttributeEvent> deleteUserAttributeEventEvent;
    Event<OnErrorEvent> errorEvent;
    NewUserAttributeEditor newUserAttributeEditor;
    public View view;
    final ListDataProvider<Map.Entry<String, String>> userAttributesProvider = new ListDataProvider();
    Map<UserManager.UserAttribute, String> attributes;
    boolean isEditMode;
    final ProvidesKey<Map.Entry<String, String>> KEY_PROVIDER = new ProvidesKey<Map.Entry<String, String>>(){

        public Object getKey(Map.Entry<String, String> item) {
            return item == null ? null : item.getKey();
        }
    };
    private final FieldUpdater keyModifiedEventHandler = new FieldUpdater<Map.Entry<String, String>, String>(){

        public void update(int index, Map.Entry<String, String> object, String value) {
            String k;
            String string = k = object != null ? object.getKey() : null;
            if (UserAttributesEditor.this.hasValueChanged(k, value)) {
                UserAttributesEditor.this.updateUserAttribute(index, value, object != null ? object.getValue() : null);
            }
        }
    };
    private final FieldUpdater valueModifiedEventHandler = new FieldUpdater<Map.Entry<String, String>, String>(){

        public void update(int index, Map.Entry<String, String> object, String value) {
            String k;
            String string = k = object != null ? object.getValue() : null;
            if (UserAttributesEditor.this.hasValueChanged(k, value)) {
                UserAttributesEditor.this.updateUserAttribute(index, object != null ? object.getKey() : null, value);
            }
        }
    };
    private final FieldUpdater removeButtonHandler = new FieldUpdater<Map.Entry<String, String>, String>(){

        public void update(int index, Map.Entry<String, String> object, String value) {
            if (value == null) {
                UserAttributesEditor.this.errorEvent.fire((Object)new OnErrorEvent((Object)UserAttributesEditor.this, UsersManagementWidgetsConstants.INSTANCE.attributeIsMandatory()));
            } else {
                UserAttributesEditor.this.confirmBox.show(UsersManagementWidgetsConstants.INSTANCE.confirmAction(), UsersManagementWidgetsConstants.INSTANCE.ensureRemoveAttribute(), () -> UserAttributesEditor.this.removeUserAttribute(index, object), () -> {});
            }
        }
    };

    @Inject
    public UserAttributesEditor(ClientUserSystemManager userSystemManager, ConfirmBox confirmBox, Event<CreateUserAttributeEvent> createUserAttributeEventEvent, Event<UpdateUserAttributeEvent> updateUserAttributeEventEvent, Event<DeleteUserAttributeEvent> deleteUserAttributeEventEvent, Event<OnErrorEvent> errorEvent, NewUserAttributeEditor newUserAttributeEditor, View view) {
        this.userSystemManager = userSystemManager;
        this.confirmBox = confirmBox;
        this.createUserAttributeEventEvent = createUserAttributeEventEvent;
        this.updateUserAttributeEventEvent = updateUserAttributeEventEvent;
        this.deleteUserAttributeEventEvent = deleteUserAttributeEventEvent;
        this.errorEvent = errorEvent;
        this.newUserAttributeEditor = newUserAttributeEditor;
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.view.initWidgets(this.newUserAttributeEditor.view);
        this.buildViewColumns();
    }

    public void show(User user) {
        this.isEditMode = false;
        this.open(user);
    }

    public void edit(User user) {
        this.isEditMode = true;
        this.open(user);
    }

    public void flush() {
        assert (this.isEditMode);
    }

    public Map<String, String> getValue() {
        HashMap<String, String> result = new HashMap<String, String>(this.attributes.size());
        for (Map.Entry<UserManager.UserAttribute, String> entry : this.attributes.entrySet()) {
            result.put(entry.getKey().getName(), entry.getValue());
        }
        return result;
    }

    public void setViolations(Set<ConstraintViolation<User>> constraintViolations) {
    }

    public void clear() {
        this.userAttributesProvider.getList().clear();
        this.attributes = null;
        this.isEditMode = false;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    void addDataDisplay(HasData<Map.Entry<String, String>> display) {
        this.userAttributesProvider.addDataDisplay(display);
    }

    protected void loadUserAttributes(User user) {
        Map properties = user.getProperties();
        if (properties != null) {
            HashMap<UserManager.UserAttribute, String> _properties = new HashMap<UserManager.UserAttribute, String>(properties.size());
            for (Map.Entry entry : properties.entrySet()) {
                String name = (String)entry.getKey();
                UserManager.UserAttribute attribute = this.getSupportedAttribute(name);
                String value = (String)entry.getValue();
                if (attribute == null) continue;
                _properties.put(attribute, value);
            }
            this.attributes = _properties;
        }
    }

    protected UserManager.UserAttribute getSupportedAttribute(String name) {
        UserManager.UserAttribute attribute = this.userSystemManager.getUserSupportedAttribute(name);
        if (attribute == null) {
            attribute = this.userSystemManager.createUserAttribute(name, false, true, null);
        }
        return attribute;
    }

    protected void open(User user) {
        this.newUserAttributeEditor.clear().showAddButton();
        this.view.setCanCreate(this.canManageAttributes());
        if (user != null) {
            this.loadUserAttributes(user);
            this.redraw();
        }
    }

    protected void redraw() {
        this.userAttributesProvider.getList().clear();
        this.buildViewColumns();
        if (this.attributes != null) {
            for (Map.Entry<UserManager.UserAttribute, String> entry : this.attributes.entrySet()) {
                UserManager.UserAttribute attribute = entry.getKey();
                String value = entry.getValue();
                Map.Entry<String, String> attrEntry = this.createAttributeEntry(attribute.getName(), value);
                this.addAttributeEntry(attrEntry);
            }
            this.view.redraw();
        } else {
            this.view.showEmpty();
        }
    }

    protected void addAttributeEntry(Map.Entry<String, String> entry) {
        List contacts = this.userAttributesProvider.getList();
        contacts.remove(entry);
        contacts.add(entry);
    }

    boolean canManageAttributes() {
        if (!this.isEditMode) {
            return false;
        }
        boolean canManageAttrs = this.userSystemManager.isUserCapabilityEnabled(Capability.CAN_MANAGE_ATTRIBUTES);
        return canManageAttrs;
    }

    protected void buildViewColumns() {
        Column<Map.Entry<String, String>, String> removeColumn;
        Column<Map.Entry<String, String>, String> valueColumn;
        int columnCount = this.view.getColumnCount();
        while (columnCount > 0) {
            this.view.removeColumn(0);
            columnCount = this.view.getColumnCount();
        }
        ColumnSortEvent.ListHandler sortHandler = new ColumnSortEvent.ListHandler(this.userAttributesProvider.getList());
        this.view.setColumnSortHandler((ColumnSortEvent.ListHandler<Map.Entry<String, String>>)sortHandler);
        Column<Map.Entry<String, String>, String> keyColumn = this.createAttributeNameColumn((ColumnSortEvent.ListHandler<Map.Entry<String, String>>)sortHandler);
        if (keyColumn != null) {
            this.view.addColumn(keyColumn, UsersManagementWidgetsConstants.INSTANCE.name());
        }
        if ((valueColumn = this.createAttributeValueColumn((ColumnSortEvent.ListHandler<Map.Entry<String, String>>)sortHandler)) != null) {
            this.view.addColumn(valueColumn, UsersManagementWidgetsConstants.INSTANCE.value());
        }
        if ((removeColumn = this.createAttributeRemoveColumn()) != null) {
            this.view.addColumn(removeColumn, UsersManagementWidgetsConstants.INSTANCE.remove());
        }
    }

    protected Column<Map.Entry<String, String>, String> createAttributeNameColumn(ColumnSortEvent.ListHandler<Map.Entry<String, String>> sortHandler) {
        EditTextCell nameCell = this.canManageAttributes() ? new EditTextCell() : new TextCell();
        Column<Map.Entry<String, String>, String> keyColumn = new Column<Map.Entry<String, String>, String>((Cell)nameCell){

            public String getValue(Map.Entry<String, String> object) {
                return object.getKey() != null ? object.getKey() : "";
            }
        };
        keyColumn.setSortable(true);
        sortHandler.setComparator((Column)keyColumn, (Comparator)new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        keyColumn.setFieldUpdater(this.canManageAttributes() ? this.keyModifiedEventHandler : null);
        return keyColumn;
    }

    protected Column<Map.Entry<String, String>, String> createAttributeValueColumn(ColumnSortEvent.ListHandler<Map.Entry<String, String>> sortHandler) {
        EditTextCell valueCell = this.canManageAttributes() ? new EditTextCell() : new TextCell();
        Column<Map.Entry<String, String>, String> valueColumn = new Column<Map.Entry<String, String>, String>((Cell)valueCell){

            public String getValue(Map.Entry<String, String> object) {
                return object.getValue() != null ? object.getValue() : "";
            }
        };
        valueColumn.setSortable(true);
        sortHandler.setComparator((Column)valueColumn, (Comparator)new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        valueColumn.setFieldUpdater(this.canManageAttributes() ? this.valueModifiedEventHandler : null);
        return valueColumn;
    }

    protected Column<Map.Entry<String, String>, String> createAttributeRemoveColumn() {
        if (!this.canManageAttributes()) {
            return null;
        }
        final ButtonCell removeButtonCell = new ButtonCell(IconType.CLOSE, ButtonType.LINK, ButtonSize.SMALL);
        Column<Map.Entry<String, String>, String> removeColumn = new Column<Map.Entry<String, String>, String>((Cell)removeButtonCell){

            public String getValue(Map.Entry<String, String> object) {
                UserManager.UserAttribute attribute;
                if (object != null && (attribute = UserAttributesEditor.this.getAttribute(object.getKey())) != null && !attribute.isMandatory() && attribute.isEditable()) {
                    removeButtonCell.setEnabled(true);
                    return "";
                }
                removeButtonCell.setEnabled(false);
                return null;
            }
        };
        removeColumn.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        removeColumn.setFieldUpdater(this.canManageAttributes() ? this.removeButtonHandler : null);
        return removeColumn;
    }

    private UserManager.UserAttribute getAttribute(String name) {
        if (!this.isEmpty(name) && this.attributes != null && !this.attributes.isEmpty()) {
            for (Map.Entry<UserManager.UserAttribute, String> entry : this.attributes.entrySet()) {
                UserManager.UserAttribute attribute = entry.getKey();
                if (!name.equals(attribute.getName())) continue;
                return attribute;
            }
        }
        return null;
    }

    private Map.Entry<String, String> createAttributeEntry(final String key, final String value) {
        return new Map.Entry<String, String>(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public String getValue() {
                return value;
            }

            @Override
            public String setValue(String value2) {
                return null;
            }
        };
    }

    private boolean hasValueChanged(String s1, String s2) {
        if (s1 != null && !s1.equals(s2)) {
            return true;
        }
        return s2 != null && !s2.equals(s1);
    }

    private boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    void updateUserAttribute(int index, String key, String value) {
        Map.Entry<String, String> attr = this.createAttributeEntry(key, value);
        UserManager.UserAttribute attribute = this.getAttribute(key);
        this.attributes.put(attribute, value);
        this.redraw();
        this.updateUserAttributeEventEvent.fire((Object)new UpdateUserAttributeEvent(this, attr));
    }

    void removeUserAttribute(int index, Map.Entry<String, String> entry) {
        UserManager.UserAttribute attribute = this.getAttribute(entry.getKey());
        this.attributes.remove(attribute);
        this.redraw();
        this.deleteUserAttributeEventEvent.fire((Object)new DeleteUserAttributeEvent(this, entry));
    }

    void onAttributeCreated(@Observes CreateUserAttributeEvent createUserAttributeEvent) {
        Map.Entry<String, String> entry = createUserAttributeEvent.getAttribute();
        String name = entry.getKey();
        String value = entry.getValue();
        UserManager.UserAttribute attribute = this.getSupportedAttribute(name);
        this.attributes.put(attribute, value);
        this.redraw();
    }

    public static interface View
    extends UberView<UserAttributesEditor> {
        public View initWidgets(NewUserAttributeEditor.View var1);

        public View setCanCreate(boolean var1);

        public View setColumnSortHandler(ColumnSortEvent.ListHandler<Map.Entry<String, String>> var1);

        public View addColumn(Column<Map.Entry<String, String>, String> var1, String var2);

        public View removeColumn(int var1);

        public int getColumnCount();

        public View showEmpty();

        public View redraw();
    }
}

