/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.role;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.validation.ConstraintViolation;
import org.jboss.errai.security.shared.api.Role;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.ACLEditor;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.ACLSettings;
import org.uberfire.ext.security.management.client.widgets.management.editor.acl.ACLViewer;
import org.uberfire.ext.security.management.client.widgets.management.events.OnEditEvent;
import org.uberfire.ext.security.management.client.widgets.management.events.OnShowEvent;
import org.uberfire.security.authz.PermissionCollection;

@Dependent
public class RoleEditor
implements IsWidget,
org.uberfire.ext.security.management.client.editor.role.RoleEditor {
    ClientUserSystemManager userSystemManager;
    ACLSettings aclSettings;
    ACLViewer aclViewer;
    ACLEditor aclEditor;
    Event<OnEditEvent> onEditEvent;
    Event<OnShowEvent> onShowEvent;
    public View view;
    Role role;
    boolean isEditMode;

    @Inject
    public RoleEditor(ClientUserSystemManager userSystemManager, ACLSettings aclSettings, ACLViewer aclViewer, ACLEditor aclEditor, Event<OnEditEvent> onEditEvent, Event<OnShowEvent> onShowEvent, View view) {
        this.userSystemManager = userSystemManager;
        this.aclSettings = aclSettings;
        this.aclViewer = aclViewer;
        this.aclEditor = aclEditor;
        this.onEditEvent = onEditEvent;
        this.onShowEvent = onShowEvent;
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.view.setACLSettings(this.aclSettings);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public String name() {
        return this.role.getName();
    }

    public PerspectiveActivity homePerspective() {
        return this.aclSettings.getHomePerspective();
    }

    public int rolePriority() {
        return this.aclSettings.getPriority();
    }

    public PermissionCollection permissions() {
        return this.aclEditor.getPermissions();
    }

    public ACLSettings getAclSettings() {
        return this.aclSettings;
    }

    public ACLEditor getAclEditor() {
        return this.aclEditor;
    }

    public void show(Role role) {
        this.clear();
        this.isEditMode = false;
        this.open(role);
        this.onShowEvent.fire((Object)new OnShowEvent(this, role));
    }

    public void edit(Role role) {
        this.clear();
        this.isEditMode = true;
        this.open(role);
    }

    public void flush() {
        assert (this.role != null);
        assert (this.isEditMode);
    }

    public Role getValue() {
        return this.role;
    }

    public void setViolations(Set<ConstraintViolation<Role>> violations) {
    }

    public void clear() {
        this.isEditMode = false;
        this.role = null;
    }

    void onEdit() {
        this.onEditEvent.fire((Object)new OnEditEvent(this, this.role));
    }

    protected void open(Role role) {
        assert (role != null);
        this.role = role;
        String name = role.getName();
        this.view.setRolename(name);
        this.view.setEditButtonVisible(!this.isEditMode);
        if (this.isEditMode) {
            this.aclSettings.edit(role);
            this.aclEditor.edit(role);
            this.view.editACL(this.aclEditor);
        } else {
            this.aclSettings.show(role);
            this.aclViewer.show(role);
            this.view.showACL(this.aclViewer);
        }
    }

    public static interface View
    extends UberView<RoleEditor> {
        public View setRolename(String var1);

        public View setEditButtonVisible(boolean var1);

        public View setACLSettings(IsWidget var1);

        public View showACL(IsWidget var1);

        public View editACL(IsWidget var1);
    }
}

