/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.widgets.management.editor.user;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.widgets.management.editor.AssignedEntitiesExplorer;
import org.uberfire.ext.security.management.client.widgets.management.editor.user.UserAssignedRolesExplorer;
import org.uberfire.ext.security.management.client.widgets.management.events.OnRemoveUserRoleEvent;
import org.uberfire.ext.security.management.client.widgets.management.list.EntitiesList;
import org.uberfire.ext.security.management.client.widgets.management.list.RolesList;
import org.uberfire.ext.security.management.client.widgets.popup.ConfirmBox;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class UserAssignedRolesExplorerTest {
    @Mock
    ClientUserSystemManager userSystemManager;
    @Mock
    EventSourceMock<OnRemoveUserRoleEvent> removeUserRoleEventEvent;
    @Mock
    ConfirmBox confirmBox;
    @Mock
    RolesList rolesList;
    @Mock
    AssignedEntitiesExplorer view;
    @Mock
    User user;
    private UserAssignedRolesExplorer tested;

    @Before
    public void setup() {
        HashMap<String, String> userAttributes = new HashMap<String, String>(1);
        userAttributes.put("attr1", "value1");
        Mockito.when((Object)this.user.getIdentifier()).thenReturn((Object)"user1");
        Mockito.when((Object)this.user.getProperties()).thenReturn(userAttributes);
        HashSet<Role> roles = new HashSet<Role>();
        Role role = (Role)Mockito.mock(Role.class);
        Mockito.when((Object)role.getName()).thenReturn((Object)"role1");
        roles.add(role);
        Mockito.when((Object)this.user.getRoles()).thenReturn(roles);
        ((ClientUserSystemManager)Mockito.doAnswer((Answer)new Answer<Role>(){

            public Role answer(InvocationOnMock invocationOnMock) throws Throwable {
                Role _role = (Role)Mockito.mock(Role.class);
                return _role;
            }
        }).when((Object)this.userSystemManager)).createRole(Matchers.anyString());
        this.tested = new UserAssignedRolesExplorer(this.userSystemManager, this.confirmBox, this.rolesList, this.view, this.removeUserRoleEventEvent);
    }

    @Test
    public void testInit() {
        this.tested.init();
        ((RolesList)Mockito.verify((Object)this.rolesList, (VerificationMode)Mockito.times((int)1))).setPageSize(Matchers.anyInt());
        ((RolesList)Mockito.verify((Object)this.rolesList, (VerificationMode)Mockito.times((int)1))).setEmptyEntitiesText(Matchers.anyString());
        ((AssignedEntitiesExplorer)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).configure(Matchers.anyString(), (EntitiesList.View)Matchers.any(EntitiesList.View.class));
        ((AssignedEntitiesExplorer)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clear();
    }

    @Test
    public void testClear() {
        this.tested.clear();
        ((AssignedEntitiesExplorer)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).configure(Matchers.anyString(), (EntitiesList.View)Matchers.any(EntitiesList.View.class));
        ((AssignedEntitiesExplorer)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((RolesList)Mockito.verify((Object)this.rolesList, (VerificationMode)Mockito.times((int)1))).clear();
        Assert.assertTrue((boolean)this.tested.entities.isEmpty());
        Assert.assertFalse((boolean)this.tested.isEditMode);
    }

    @Test
    public void testShow() {
        this.tested.show(this.user);
        Assert.assertFalse((boolean)this.tested.isEditMode);
        Assert.assertTrue((this.tested.entities.size() == 1 ? 1 : 0) != 0);
        ((AssignedEntitiesExplorer)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).configure(Matchers.anyString(), (EntitiesList.View)Matchers.any(EntitiesList.View.class));
        ((AssignedEntitiesExplorer)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((RolesList)Mockito.verify((Object)this.rolesList, (VerificationMode)Mockito.times((int)1))).clear();
        ((RolesList)Mockito.verify((Object)this.rolesList, (VerificationMode)Mockito.times((int)1))).show((Collection)Mockito.anySet(), (EntitiesList.Callback)Matchers.any(EntitiesList.Callback.class));
    }

    @Test
    public void testRemoveRole() {
        Role r = (Role)Mockito.mock(Role.class);
        Mockito.when((Object)r.getName()).thenReturn((Object)"role1");
        this.tested.entities.add(r);
        this.tested.removeEntity("role1");
        Assert.assertFalse((boolean)this.tested.isEditMode);
        Assert.assertTrue((this.tested.entities.size() == 0 ? 1 : 0) != 0);
        ((RolesList)Mockito.verify((Object)this.rolesList, (VerificationMode)Mockito.times((int)1))).show((Collection)Mockito.anySet(), (EntitiesList.Callback)Matchers.any(EntitiesList.Callback.class));
        ((EventSourceMock)Mockito.verify(this.removeUserRoleEventEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(OnRemoveUserRoleEvent.class));
        ((AssignedEntitiesExplorer)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).configure(Matchers.anyString(), (EntitiesList.View)Matchers.any(EntitiesList.View.class));
        ((AssignedEntitiesExplorer)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clear();
        ((RolesList)Mockito.verify((Object)this.rolesList, (VerificationMode)Mockito.times((int)0))).clear();
    }
}

